﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Validation;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation
{
    ///<summary>
    /// ValidationResultのテストクラスです。
    ///</summary>

    [TestClass()]
    public class ValidationResultTest
    {


        private TestContext testContextInstance;

        ///<summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion



        ///<summary>
        /// ValidationResultのテスト
        ///</summary>
        ///<remarks>
        /// ValidationResultをデフォルトコンストラクタでインスタンス化した場合、
        /// 正常にインスタンス化されることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            //実行
            ValidationResult target = new ValidationResult();

            //検証
            Assert.IsNotNull(target);
            Assert.IsNotNull(target.Errors);
            Assert.AreEqual(0, target.Errors.Count);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationResult), LogLevel.INFO));

        }

        ///<summary>
        /// Errors のテスト
        ///</summary>
        ///<remarks>
        /// デフォルトコンストラクタでインスタンス化した場合、
        /// Errorsプロパティ(IList)がインスタンス化されることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ErrorsTest01()
        {
            ValidationResult target = new ValidationResult();
            Assert.IsNotNull(target.Errors);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationResult), LogLevel.INFO));

        }

        ///<summary>
        /// Errors のテスト
        ///</summary>
        ///<remarks>
        /// Errorsプロパティ(IList)に値を設定した場合、
        /// 同じ参照(IList)をValidationResultから取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ErrorsTest02()
        {
            ValidationResult target = new ValidationResult();
            IList<MessageInfo> msgList = target.Errors;
            Assert.AreEqual(0, target.Errors.Count);

            string key = "ERR001";
            string message = "Error Message";
            MessageInfo msg = new MessageInfo(key, message);
            msgList.Add(msg);

            Assert.AreEqual(1, target.Errors.Count);
            Assert.AreEqual(key, target.Errors[0].Key);
            Assert.AreEqual(message, target.Errors[0].Message);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationResult), LogLevel.INFO));

        }

        ///<summary>
        /// IsValid のテスト
        ///</summary>
        ///<remarks>
        /// デフォルトコンストラクタでインスタンス化した場合、
        /// InValidの返却値がtrueであることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void IsValidTest01()
        {
            ValidationResult target = new ValidationResult();
            Assert.IsTrue(target.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationResult), LogLevel.INFO));

        }

        ///<summary>
        /// IsValid のテスト
        ///</summary>
        ///<remarks>
        /// ErrorsプロパティにMessageInfoを設定した場合、
        /// InValidの返却値がfalseであることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void IsValidTest02()
        {
            ValidationResult target = new ValidationResult();
            IList<MessageInfo> msgList = target.Errors;
            MessageInfo msg = new MessageInfo("ERR001", "Error Message");
            msgList.Add(msg);
            Assert.IsFalse(target.IsValid);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationResult), LogLevel.INFO));

        }
    }
}
