﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.Validation;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT.Validation
{
    ///<summary>
    /// ValidationMessageInfoのテストクラスです。
    ///</summary>

    [TestClass()]
    public class ValidationMessageInfoTest
    {


        private TestContext testContextInstance;

        ///<summary>
        /// 現在のテストの実行についての情報および機能を
        /// 提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        ///<summary>
        /// ErrorPath のテスト
        ///</summary>
        ///<remarks>
        /// ErrorPathプロパティに値をセットした場合、その値をゲットできることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ErrorPathTest01()
        {
            string errorCode = null;
            string message = null;
            string errorPath = null;
            ValidationMessageInfo target = new ValidationMessageInfo(errorCode, message, errorPath);
            string val = "ErrorPathTest01";
            target.ErrorPath = val;
            Assert.AreEqual(val, target.ErrorPath);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationMessageInfo), LogLevel.INFO));

        }

        ///<summary>
        /// ErrorTitle のテスト
        ///</summary>
        ///<remarks>
        /// ErrorTitleプロパティに値をセットした場合、その値がゲットできることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ErrorTitleTest01()
        {
            string errorCode = null;
            string message = null;
            string errorPath = null;
            ValidationMessageInfo target = new ValidationMessageInfo(errorCode, message, errorPath);
            string val = "ErrorTitleTest01";
            target.ErrorTitle = val;
            Assert.AreEqual(val, target.ErrorTitle);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationMessageInfo), LogLevel.INFO));

        }

        ///<summary>
        /// ErrorTypeName のテスト
        ///</summary>
        ///<remarks>
        /// ErrorTypeプロパティに値をセットした場合、その値がゲットできることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ErrorTypeNameTest01()
        {
            string errorCode = null;
            string message = null;
            string errorPath = null;
            ValidationMessageInfo target = new ValidationMessageInfo(errorCode, message, errorPath);
            string val = "ErrorTypeNameTest01";
            target.ErrorTypeName = val;
            Assert.AreEqual(val, target.ErrorTypeName);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationMessageInfo), LogLevel.INFO));

        }

        ///<summary>
        /// ValidationMessageInfo (string, string, string) のテスト
        ///</summary>
        ///<remarks>
        /// errorCode,message,errorPathが正常な値の場合、
        /// 正常にインスタンス化され、プロパティアクセスで全ての値を取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorStringStringStringTest01()
        {
            string errorCode = "エラーコード";
            string message = "メッセージ";
            string errorPath = "エラーパス";
            ValidationMessageInfo target = new ValidationMessageInfo(errorCode, message, errorPath);
            Assert.AreEqual(errorCode, target.Key);
            Assert.AreEqual(message, target.Message);
            Assert.AreEqual(errorPath, target.ErrorPath);
            Assert.IsNull(target.ErrorTitle);
            Assert.IsNull(target.ErrorTypeName);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationMessageInfo), LogLevel.INFO));

        }

        ///<summary>
        /// ValidationMessageInfo (string, string, string, string, string) のテスト
        ///</summary>
        ///<remarks>
        /// errorCode,message,errorPath,errorTypeName,errorTitleが正常な値の場合、
        /// 正常にインスタンス化され、プロパティアクセスで全ての値を取得できることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorStringStringStringStringStringTest01()
        {
            string errorCode = "エラーコード";
            string message = "メッセージ";
            string errorPath = "エラーパス";
            string errorTypeName = "エラータイプ名";
            string errorTitle = "エラータイトル";

            ValidationMessageInfo target = new ValidationMessageInfo(
                errorCode, message, errorPath, errorTypeName, errorTitle);

            Assert.AreEqual(errorCode, target.Key);
            Assert.AreEqual(message, target.Message);
            Assert.AreEqual(errorPath, target.ErrorPath);
            Assert.AreEqual(errorTypeName, target.ErrorTypeName);
            Assert.AreEqual(errorTitle, target.ErrorTitle);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ValidationMessageInfo), LogLevel.INFO));

        }
    }
}
