// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Validation.Validators;

namespace TERASOLUNA.Fw.Common.Validation.Configuration
{
    /// <summary>
    /// ݒ񂩂 <see cref="DateTimeRangeValidatorEx"/> 𐶐E邽߂ <see cref="ValidatorData"/> pNXłB
    /// </summary>
    public class DateTimeRangeValidatorExData : RangeValidatorData<DateTime>
    {
        /// <summary>
        /// <see cref="DateTimeRangeValidatorExData"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public DateTimeRangeValidatorExData()
        { }

        /// <summary>
        /// ݒ <see cref="DateTimeRangeValidatorEx"/> ̃CX^X𐶐܂B
        /// </summary>
        /// <remarks>
        /// <see cref="DateTimeRangeValidatorEx"/> ̃CX^X𐶐Aԋp܂B
        /// </remarks>
        /// <param name="targetType">ؑΏۂ̒ľ^B</param>
        /// <returns>ꂽ <see cref="DateTimeRangeValidatorEx"/> B</returns>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="RangeValidatorData{T}.LowerBound"/>  <seealso cref="RangeValidatorData{T}.UpperBound"/> 傫łB
        /// </item>
        /// <item>
        /// <seealso cref="RangeValidatorData{T}.LowerBoundType"/>  <seealso cref="RangeValidatorData{T}.UpperBoundType"/> 
        ///  <seealso cref="RangeBoundaryType.Ignore"/> łB
        /// </item>
        /// <item>
        /// <seealso cref="RangeValidatorData{T}.LowerBound"/> A <seealso cref="RangeValidatorData{T}.UpperBound"/> ̂ꂩA
        ///  <seealso cref="RangeBoundaryType.Ignore"/> ȊOɎw肳ĂA null łB
        /// </item>
        /// </list>
        /// </exception> 
        protected override Validator DoCreateValidator(Type targetType)
        {
            return new DateTimeRangeValidatorEx(LowerBound,
                                         LowerBoundType,
                                         UpperBound,
                                         UpperBoundType,
                                         MessageTemplate,
                                         Negated);
        }
    }
}
