// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.ClientUT.BLogic.ClientBLogicBaseData;
using TERASOLUNA.Fw.Client.BLogic;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.ClientUT.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.BLogic.ClientBLogicBase のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.BLogic.ClientBLogicBase 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ClientBLogicBaseTest
    {


        private TestContext testContextInstance;

        private bool _callDoTestProgressChanged = false;

        private object _sender = null;

        private ExecuteProgressChangedEventArgs _e = null;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        ///<summary>
        /// Cancel() のテスト
        ///</summary>
        ///<remarks>
        /// Cancelledプロパティに true が設定されていることを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void CancelledTest01()
        {
            // 準備
            ClientBLogicBaseImpl target = new ClientBLogicBaseImpl();

            // 実施
            target.Cancel();

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ClientBLogicBase), LogLevel.INFO));
        }

        /// <summary>
        /// OnProgressChanged(ExecuteProgressChangedEventArgs) のテスト
        /// </summary>
        /// <remarks>
        /// イベント ProgressChangedが登録されていない場合、正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void OnProgressChanged01()
        {
            // 準備
            ClientBLogicBaseImpl target = new ClientBLogicBaseImpl();
            ExecuteProgressChangedEventArgs args = new ExecuteProgressChangedEventArgs(100);

            // 実施
            target.CallOnProgressChanged(args);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ClientBLogicBase), LogLevel.INFO));
        }

        /// <summary>
        /// OnProgressChanged(ExecuteProgressChangedEventArgs) のテスト
        /// </summary>
        /// <remarks>
        /// イベント ProgressChangedが登録されている場合、正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void OnProgressChanged02()
        {
            // 準備
            ClientBLogicBaseImpl target = new ClientBLogicBaseImpl();
            target.ProgressChanged += new ExecuteProgressChangedEventHandler(DoTestProgressChanged);
            ExecuteProgressChangedEventArgs e = new ExecuteProgressChangedEventArgs(100);
            _callDoTestProgressChanged = false;
            _sender = null;
            _e = null;

            // 実施
            target.CallOnProgressChanged(e);

            // 確認
            Assert.IsTrue(_callDoTestProgressChanged);
            Assert.AreSame(_sender, target);
            Assert.AreSame(_e, e);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ClientBLogicBase), LogLevel.INFO));
        }

        /// <summary>
        /// イベントに登録するためのメソッド。
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        public void DoTestProgressChanged(object sender, ExecuteProgressChangedEventArgs e)
        {
            _callDoTestProgressChanged = true;
            _sender = sender;
            _e = e;
        }
    }
}
