﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;
using System.Data;

namespace TERASOLUNA.Fw.Client.Configuration.Conversion
{
    /// <summary>
    /// データセット変換設定ファイル内の clear-view 要素を表します。
    /// </summary>
    /// <remarks>
    /// <para>
    /// <see cref="TERASOLUNA.Fw.Client.Conversion.IConverter.Reverse">IConverter.Reverse</see> 
    /// 実行時に、変換先 <see cref="DataSet"/> 内のクリアしたい 
    /// <see cref="DataTable"/> を定義する要素です。
    /// </para>
    /// <para>
    /// clear-view 要素は、以下の属性を含みます。
    /// <list type="table">
    /// <listheader>
    /// <description>属性</description>
    /// <description>説明</description>
    /// </listheader>
    /// <item>
    /// <description>table</description>
    /// <description>
    /// 必須の属性です。画面 <see cref="DataSet"/> 内のクリアしたいテーブル名を指定します。
    /// </description>
    /// </item>
    /// </list>
    /// </para>
    /// </remarks>
    public sealed class ClearViewElement : ConfigurationElement
    {
        /// <summary>
        /// table 属性を表す名前です。
        /// </summary>
        /// <remarks>
        /// この定数の値は "table" です。
        /// </remarks>
        private const string ATTRIBUTE_NAME_TABLE = "table";

        /// <summary>
        /// <see cref="ClearViewElement" /> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public ClearViewElement()
        {
        }

        /// <summary>
        /// <see cref="ClearViewElement" /> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="table">table 属性に指定されたテーブル名。</param>
        /// <remarks>
        /// clear-view 要素の属性の値を初期化します。
        /// </remarks>
        public ClearViewElement(string table)
        {
            this[ATTRIBUTE_NAME_TABLE] = table;
        }

        /// <summary>
        /// table 属性の値を取得します。
        /// </summary>
        /// <value>
        /// table 属性の値。
        /// </value>
        [ConfigurationProperty(ATTRIBUTE_NAME_TABLE, IsRequired = true, IsKey = true)]
        public string TableName
        {
            get
            {
                return (string)this[ATTRIBUTE_NAME_TABLE];
            }
        }
    }
}
