// <쌠>
// Copyright (c) 2006-2007, NTT DATA Corporation.  

using System;
using System.Text;
using System.Data;
using System.Configuration;
using System.Net;
using NTTDATA.TERASOLUNA.FW.Common;
using System.IO;
using System.Collections.Specialized;
using System.Collections;

namespace NTTDATA.TERASOLUNA.FW.Client.Communication
{
    /// <summary>
    /// t@CAbv[hE_E[h@\񋟂NXłB
    /// </summary>
    /// <author>
    /// V菲[
    /// </author>
    public class FileCommunicator : Communicator
    {
        /// <summary>
        /// ReLXg̎ނHTTPwb_֊i[ۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "application/octet-stream" łB</para></remarks>
        protected static readonly string CONTENT_TYPE_BINARY = "application/octet-stream";
        
        /// <summary>
        /// Abv[ht@CHTTPwb_֊i[ۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "Content-Disposition" łB</para></remarks>
        protected static readonly string CONTENT_DISPOSITION = "Content-Disposition";

        /// <summary>
        /// Content-Dispositionփt@Cݒ肷ۂɗp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "attachment; filename=?{0}?{1}?{2}?=" łB</para></remarks>
        protected static readonly string CONTENT_DISPOSITION_VALUE = "attachment; filename=?{0}?{1}?{2}?=";

        /// <summary>
        /// Content-Disposition̒lt@C擾ۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "filename" łB</para></remarks>
        protected static readonly string CONTENT_DISPOSITION_FILENAME = "filename";

        /// <summary>
        /// t@CGR[h^fR[hۂɗp镶R[h\łB
        /// </summary>
        /// <remarks>
        /// <para>̒萔̒l "ISO-2022-JP" łB</para>
        /// <para>ISO-2022-JṔAC^[lbg(E[)Ŏg{ꕶ̕łB</para>
        /// <para>RFC1468Œ`Ă܂BJISR[hƂĂ΂Ă܂B</para>
        /// <para>ISO/IEC 2022̃GXP[vV[PX𗘗pĕW؂ւ7rbg̃R[hł邱ƂłB</para>
        /// </remarks>
        protected static readonly string ENCODE_CHAR = "ISO-2022-JP";

        /// <summary>
        /// T[oM_E[ht@CCxgnh֑MۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "ContentFileName" łB</para></remarks>
        public static readonly string CONTENT_FILENAME = "ContentFileName";

        /// <summary>
        /// _E[ht@C̏o̓pX擾ۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "DownloadFilePath" łB</para></remarks>
        public static readonly string DOWNLOAD_FILEPATH = "DownloadFilePath";

        /// <summary>
        /// is󋵃Cxgnhփ_E[hʒmsۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "DownloadReady" łB</para></remarks>
        public static readonly string DOWNLOAD_READY = "DownloadReady";

        /// <summary>
        /// _E[hsʃR[h\łB
        /// </summary>
        /// <remarks><para>̒萔̒l "downloadFailure" łB</para></remarks>
        public static readonly string DOWNLOAD_FAILURE_CODE = "downloadFailure";

        /// <summary>
        /// t@C̃GR[h^fR[h̃^Cv\łB
        /// </summary>
        /// <remarks>
        /// <para>̒萔̒l "B" łB"B"́ABGR[h\܂B</para>
        /// <para>BGR[hƂ́A7bit US-ASCIIȊÕeLXggp邽߂7bitGR[fBOJjŸłB</para>
        /// <para>RFC2047Œ`Ă܂BGR[fBOASYBase64ƓłB</para>
        /// <para>BGR[hȊOQGR[h܂B</para>
        /// <para>QGR[hƂ́A7bit US-ASCIIȊÕeLXggp邽߂7bitGR[fBOJjŸłB</para>
        /// <para>RFC2047Œ`Ă܂BGR[fBOASYQuoted PrintableɎĂ܂A󔒂̈ȂǂقȂ܂B</para>
        /// <para>QGR[hꂽeLXĝA7bit US-ASCIIŏꂽ̓fR[_ȂĂقڂ̂܂ܓǂ߂邽߁A7bit US-ASCIIŜ8`9ȏ߂鐼[bp̃eLXgGR[hꍇɎgp܂B</para>
        /// <para>{̃eLXgGR[hꍇ́ABGR[hg܂B</para> 
        /// </remarks>
        public static readonly string ENCODE_TYPE = "B";

        /// <summary>
        /// t@CGR[h^fR[hۂɗp<see cref="Encoding"/>łB
        /// </summary>
        private Encoding _fileNameEncoding = Encoding.GetEncoding(ENCODE_CHAR);

        /// <summary>
        /// t@CGR[h^fR[hۂɗp<see cref="Encoding"/>擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>
        /// t@CGR[h^fR[hۂɗp<see cref="Encoding"/>B
        /// </value>
        /// <remarks>
        /// ftHg<see cref="ENCODE_CHAR"/>`<see cref="Encoding"/>łB
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// nullݒ肵ꍇB
        /// </exception>
        public Encoding FileNameEncoding
        {
            get
            {
                return _fileNameEncoding;
            }
            set
            {
                if (value == null)
                {
                    throw new ArgumentNullException("FileNameEncoding");
                }
                _fileNameEncoding = value;
            }
        }

        /// <summary>
        /// <see cref="FileCommunicator"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public FileCommunicator()
        {
        }

        /// <summary>
        /// t@CAbv[hs܂B
        /// </summary>
        /// <param name="requestName">T[o֑M郊NGXgB</param>
        /// <param name="filePath">T[oփAbv[ht@CpXi΃pX܂͐΃pXjB</param>
        /// <param name="receiveData">Abv[hʂi[M <see cref="DataSet"/>B</param>
        /// <returns>Abv[hʂێ <see cref="CommunicationResult"/>B</returns>
        /// <remarks>
        /// <para><paramref name="filePath"/>Ŏw肵t@CABase64GR[hăNGXg̃wb_֊i[܂B</para>
        /// <para><see cref="Communicator.BufferSize"/>Ŏw肵TCỸoCif[^𑗐M邽тɁA<see cref="Communicator.ProgressChanged"/>Cxg𔭍s܂B</para>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <para><paramref name="requestName"/>  null QƂłB</para>
        /// <para><paramref name="filePath"/>  null QƂłB</para>
        /// <para><paramref name="receiveData"/>  null QƂłB</para>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <para><paramref name="requestName"/> 󕶎łB</para>
        /// <para><paramref name="filePath"/> 󕶎łB</para>
        /// </exception>
        /// <exception cref="FileNotFoundException">
        /// <paramref name="filePath"/>Ŏw肳ꂽt@C܂łB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>AHTTP`ł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>ANGXg擾ł܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="CommunicationException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>ɁAURLݒ肳Ă܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Mf[^XMLdł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// MXMLdɃ[gm[h܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// ʐMɃG[܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="System.Security.SecurityException">
        /// Abv[ht@CɕKvȃANZX܂B
        /// </exception>
        /// <exception cref="PathTooLongException">
        /// Abv[ht@CpXAAbv[ht@CA܂̗͂VXe`̍ő咷𒴂Ă܂BƂ΁AWindows x[X̃vbgtH[̏ꍇApX̒ 248 At@C̒ 260 łKv܂B
        /// </exception>
        public virtual CommunicationResult Upload(string requestName, string filePath, DataSet receiveData)
        {
            if (requestName == null)
            {
                throw new ArgumentNullException("requestName");
            }
            if (requestName.Length == 0)
            {
                throw new ArgumentException(Properties.Resources.E_EMPTY_STRING, "requestName");
            } 
            if (filePath == null)
            {
                throw new ArgumentNullException("filePath");
            }
            if (filePath.Length == 0)
            {
                throw new ArgumentException(Properties.Resources.E_EMPTY_STRING, "filePath");
            } 
            if (receiveData == null)
            {
                throw new ArgumentNullException("receiveData");
            }

            // t@C݃`FbN
            if (!File.Exists(filePath))
            {
                throw new FileNotFoundException(string.Format(Properties.Resources.E_COMMUNICATION_FILE_NOT_FOUND, filePath));
            }

            CommunicationResult resultData = null;

            try
            {
                // oCif[^M
                SendBinary(requestName, filePath);

                // DTOM
                resultData = Receive(receiveData);
            }
            catch (WebException e)
            {
                throw new CommunicationException(Properties.Resources.E_COMMUNICATION_EXCEPTION, e);
            }

            return resultData;
        }

        /// <summary>
        /// oCif[^Ms܂B
        /// </summary>
        /// <param name="requestName">T[o֑M郊NGXgB</param>
        /// <param name="filePath">T[oփAbv[ht@CpXB</param>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>AHTTP`ł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>ANGXg擾ł܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="WebException">
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>ɁAURLݒ肳Ă܂B
        /// </exception>
        /// <exception cref="System.Security.SecurityException">
        /// <paramref name="filePath"/>Ŏw肵t@CɕKvȃANZX܂B
        /// </exception>
        /// <exception cref="PathTooLongException">
        /// <paramref name="filePath"/>Ŏw肵t@CpXAt@CA܂̗͂VXe`̍ő咷𒴂Ă܂BƂ΁AWindows x[X̃vbgtH[̏ꍇApX̒ 248 At@C̒ 260 łKv܂B
        /// </exception>
        protected virtual void SendBinary(string requestName, string filePath)
        {
            // NGXg擾
            InitializeRequest();

            // NGXg̃wb_[ݒ
            string fileName = Path.GetFileName(filePath);
            PrepareRequest(requestName, fileName);

            // Abv[ht@C̓ǂݍݏ
            using (Stream upFileStream = new FileStream(filePath, FileMode.Open, FileAccess.Read))
            {
                int sendSize = 0;
                long totalSize = upFileStream.Length;

                // ContentLength̐ݒ
                Request.ContentLength = totalSize;

                // NGXg֏ݏ
                using (Stream reqStream = Request.GetRequestStream())
                {
                    byte[] buffer = new byte[BufferSize];
                    int bufferSize = upFileStream.Read(buffer, 0, BufferSize);
                    while (bufferSize > 0)
                    {
                        // NGXgփoCif[^
                        reqStream.Write(buffer, 0, bufferSize);

                        // Cxgʒm
                        sendSize += bufferSize;
                        int percentage = (int)(sendSize * 50 / totalSize);
                        OnProgressChanged(new ExecuteProgressChangedEventArgs(percentage));

                        bufferSize = upFileStream.Read(buffer, 0, BufferSize);
                    }
                }
            }
        }

        /// <summary>
        /// NGXg̃wb_[֎w肵ڂƒlǉ܂B
        /// </summary>
        /// <param name="requestName">T[o֑M郊NGXgB</param>
        /// <param name="fileName">T[oփAbv[ht@CB</param>
        /// <remarks>
        /// <para><see cref="HttpWebRequest"/><see cref="HttpWebRequest.Method"/><see cref="Communicator.POST"/>o^܂B</para>
        /// <para><see cref="HttpWebRequest"/><see cref="HttpWebRequest.ContentType"/><see cref="CONTENT_TYPE_BINARY"/>o^܂B</para>
        /// <para><see cref="HttpWebRequest"/><see cref="HttpWebRequest.Headers"/><paramref name="requestName"/>o^܂BL[<see cref="Communicator.REQUEST_NAME"/>łB</para>
        /// <para><see cref="HttpWebRequest"/><see cref="HttpWebRequest.Headers"/><see cref="Communicator.LogonId"/>o^܂BL[<see cref="Communicator.LOGON_ID"/>łB</para>
        /// <para><see cref="HttpWebRequest"/><see cref="HttpWebRequest.Headers"/><see cref="Communicator.LogonPassword"/>o^܂BL[<see cref="Communicator.LOGON_PASSWORD"/>łB</para>
        /// <para><see cref="HttpWebRequest"/><see cref="HttpWebRequest.Headers"/><paramref name="fileName"/>o^܂BL[<see cref="CONTENT_DISPOSITION"/>łB</para>
        /// <para>܂A<paramref name="fileName"/>́ABase64ŃGR[h܂B</para>
        /// </remarks>
        protected virtual void PrepareRequest(string requestName, string fileName)
        {

            Request.Method = POST;
            Request.AllowAutoRedirect = false;
            Request.ContentType = CONTENT_TYPE_BINARY;
            Request.Headers.Add(REQUEST_NAME, requestName);
            Request.Headers.Add(LOGON_ID, LogonId);
            Request.Headers.Add(LOGON_PASSWORD, LogonPassword);
            Request.Headers.Add(CONTENT_DISPOSITION, EncodeFileName(fileName));
            
        }

        /// <summary>
        /// Abv[ht@CBase64փGR[hāAContent-Disposition֊i[镶쐬܂B
        /// </summary>
        /// <param name="fileName">Abv[ht@CB</param>
        /// <returns>Content-Disposition֊i[镶B</returns>
        protected virtual string EncodeFileName(string fileName)
        {

            byte[] byteData = _fileNameEncoding.GetBytes(fileName);

            return string.Format(CONTENT_DISPOSITION_VALUE, _fileNameEncoding.WebName, ENCODE_TYPE, Convert.ToBase64String(byteData));

        }

        /// <summary>
        /// t@C̃_E[hs܂B
        /// </summary>
        /// <param name="requestName">T[o֑M郊NGXgB</param>
        /// <param name="sendData">M <see cref="DataSet"/>B</param>
        /// <returns>_E[hʂێ <see cref="CommunicationResult"/>B</returns>
        /// <remarks>
        /// <para>T[oŃG[ꍇA<see cref="CommunicationResult"/>ɃG[񂪊i[܂B</para>
        /// <para>_E[hsOɁA<see cref="Communicator.ProgressChanged"/>Cxg𔭍s܂B</para>
        /// <para><see cref="Communicator.ProgressChanged"/>CxgŎ擾t@CpXփoCif[^o͂܂B</para>
        /// <para>o̓t@CpX擾łȂꍇA<see cref="CommunicationResult.ErrorType"/><see cref="DOWNLOAD_FAILURE_CODE"/>i[܂B</para>
        /// <para>t@Cɑ݂ꍇA_E[ht@Cŏ㏑܂B</para>
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <para><paramref name="requestName"/>  null QƂłB</para>
        /// <para><paramref name="sendData"/>  null QƂłB</para>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="requestName"/> 󕶎łB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>AHTTP`ł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>ANGXg擾ł܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="CommunicationException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// AvP[V\t@C<see cref="Communicator.BASE_URL"/>ɁAURLݒ肳Ă܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Mf[^XMLdł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// MXMLdɃ[gm[h܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Content-DispositionɊ܂܂GR[h́AT|[gĂ܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// ʐMɃG[܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="IOException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// _E[hꎞt@C쐬ł܂łB
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// _E[hpXŎw肵t@CAǂݎp܂ overwrite  false ̂ߏ㏑ł܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>      
        /// <exception cref="ArgumentException">
        /// _E[hpXɖȕ܂܂Ă܂B
        /// </exception>
        /// <exception cref="System.Security.SecurityException">
        /// _E[hpXɕKvȃANZX܂B
        /// </exception>
        /// <exception cref="DirectoryNotFoundException">
        /// _E[hpXA蓖ĂĂȂhCułȂǁAw肳ꂽpXłB
        /// </exception>
        /// <exception cref="UnauthorizedAccessException">
        /// t@C܂̓fBNgǂݎpɐݒ肳ĂȂǁA_E[hpXɑ΂ access vIy[eBO VXeŋ܂B
        /// </exception>
        /// <exception cref="PathTooLongException">
        /// _E[hpXA_E[ht@CA܂̗͂VXe`̍ő咷𒴂Ă܂BƂ΁AWindows x[X̃vbgtH[̏ꍇApX̒ 248 At@C̒ 260 łKv܂B
        /// </exception>
        public virtual CommunicationResult Download(string requestName, DataSet sendData)
        {
            if (requestName == null)
            {
                throw new ArgumentNullException("requestName");
            }
            if (requestName.Length == 0)
            {
                throw new ArgumentException(Properties.Resources.E_EMPTY_STRING, "requestName");
            }
            if (sendData == null)
            {
                throw new ArgumentNullException("sendData");
            }

            CommunicationResult resultData = null;

            try
            {
                // DTOM
                Send(requestName, sendData);

                // _E[h
                resultData = ReceiveData();
            }
            catch (WebException e)
            {
                throw new CommunicationException(Properties.Resources.E_COMMUNICATION_EXCEPTION, e);
            }

            return resultData;
        }

        /// <summary>
        /// T[of[^M܂B
        /// </summary>
        /// <returns>_E[hʂێ <see cref="CommunicationResult"/>B</returns>
        /// <exception cref="WebException">
        /// ʐMɃG[܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// Mf[^XMLdł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// MXMLdɃ[gm[h܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Content-DispositionɊ܂܂GR[h́AT|[gĂ܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="IOException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// _E[hꎞt@C쐬ł܂łB
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// _E[hpXŎw肵t@CAǂݎp܂ overwrite  false ̂ߏ㏑ł܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// _E[hpXɖȕ܂܂Ă܂B
        /// </exception>
        /// <exception cref="System.Security.SecurityException">
        /// _E[hpXɕKvȃANZX܂B
        /// </exception>
        /// <exception cref="DirectoryNotFoundException">
        /// _E[hpXA蓖ĂĂȂhCułȂǁAw肳ꂽpXłB
        /// </exception>
        /// <exception cref="UnauthorizedAccessException">
        /// t@C܂̓fBNgǂݎpɐݒ肳ĂȂǁA_E[hpXɑ΂ access vIy[eBO VXeŋ܂B
        /// </exception>
        /// <exception cref="PathTooLongException">
        /// _E[hpXA_E[ht@CA܂̗͂VXe`̍ő咷𒴂Ă܂BƂ΁AWindows x[X̃vbgtH[̏ꍇApX̒ 248 At@C̒ 260 łKv܂B
        /// </exception>
        protected virtual CommunicationResult ReceiveData()
        { 
        
            CommunicationResult resultData = new CommunicationResult();

            // X|X擾
            using (WebResponse response = Request.GetResponse())
            {
                // X|X̃wb_Exception擾
                string errorType = response.Headers[ERROR_TYPE];
                if (errorType == null)
                {
                    // Content-Dispositiont@C擾
                    string contentFileName = GetContentFileName(response);

                    // oCif[^̏o̓pX擾
                    string filePath = GetDownloadFilePath(contentFileName);

                    if (string.IsNullOrEmpty(filePath))
                    {
                        resultData.ErrorType = DOWNLOAD_FAILURE_CODE;
                    }
                    else
                    {
                        // _E[h
                        ReceiveBinary(response, filePath);
                    }
                }
                else
                {
                    // T[õG[M
                    resultData = HandleReceiveData(response, new DataSet());
                }
            }

            return resultData;   
        }

        /// <summary>
        /// T[oMt@C擾܂B
        /// </summary>
        /// <param name="response">X|Xf[^B</param>
        /// <returns>T[o瑗Mꂽ_E[ht@CB</returns>
        /// <exception cref="CommunicationException">
        /// Content-DispositionɊ܂܂GR[h́AT|[gĂ܂B
        /// </exception>
        protected virtual string GetContentFileName(WebResponse response)
        {
            string contentDisposition = response.Headers.Get(CONTENT_DISPOSITION);

            string contentFileName = null;

            if (contentDisposition != null)
            {
                string[] strArray = contentDisposition.Split(';');
                if (strArray.Length > 1)
                {
                    // filenameȍ~̕擾
                    contentDisposition = strArray[1];
                    
                    // ŏ'='ŕ𕪊
                    int substrPos = contentDisposition.IndexOf('=');
                    if (substrPos >= 0)
                    {
                        string keyStr = contentDisposition.Substring(0, substrPos).Trim();
                        string valueStr = contentDisposition.Substring(substrPos + 1).Trim();
                        // filenameȍ~̕擾
                        if (CONTENT_DISPOSITION_FILENAME.Equals(keyStr) && !string.IsNullOrEmpty(valueStr))
                        {
                            contentFileName = DecodeFileName(valueStr);
                        }
                    }
                }
            }

            return contentFileName;
        }


        /// <summary>
        /// Content-Disposition 擾t@CfR[h܂B
        /// </summary>
        /// <param name="encodeStr">GR[hꂽt@C܂ޕB</param>
        /// <returns>fR[ht@CB</returns>
        /// <remarks>
        /// <para>Content-Disposition Ɋ܂܂GR[h "B" ̏ꍇAfR[ht@Cԋp܂B</para>
        /// <para>"B" ȊÕGR[hw肳ꂽꍇ́Anull ԋp܂B</para>
        /// </remarks>
        /// <exception cref="CommunicationException">
        /// Content-Disposition Ɋ܂܂GR[h́AT|[gĂ܂B
        /// </exception>
        protected virtual string DecodeFileName(string encodeStr)
        {
            string fileName = null;

            // vf𕪉
            string[] strArray = encodeStr.Split('?');
            if (strArray.Length >= 5)
            {
                // Base64`̂ݑΉ
                if (ENCODE_TYPE.Equals(strArray[2]))
                {
                    byte[] byteArray = Convert.FromBase64String(strArray[3]);

                    try
                    {
                        fileName = Encoding.GetEncoding(strArray[1]).GetString(byteArray);
                    }
                    catch (ArgumentException e)
                    {
                        throw new CommunicationException(string.Format(Properties.Resources.E_COMMUNICATION_INVALID_ENCODING, strArray[1]), e);
                    }
                }
            }
            return fileName;
        }

        /// <summary>
        /// is󋵃CxgnhA_E[ht@C̏o̓pX擾܂B
        /// </summary>
        /// <param name="contentFileName">T[o瑗Mꂽ_E[ht@CB</param>
        /// <returns>_E[ht@CpXB</returns>
        protected virtual string GetDownloadFilePath(string contentFileName)
        {
            // ProgressChangedCxg(_E[hJnʒm)
            ExecuteProgressChangedEventArgs eventArgs = new ExecuteProgressChangedEventArgs(50);
            eventArgs.Items.Add(DOWNLOAD_READY, true);
            eventArgs.Items.Add(CONTENT_FILENAME, contentFileName);

            OnProgressChanged(eventArgs);

            // _E[ht@CpX
            return eventArgs.Items[DOWNLOAD_FILEPATH] as string;
        }

        /// <summary>
        /// _E[hoCif[^ꎞt@C֏o͌A<paramref name="filePath"/>փRs[܂B
        /// </summary>
        /// <param name="response">X|Xf[^B</param>
        /// <param name="filePath">_E[hpXB</param>
        /// <remarks>
        /// <para>_E[h̐IEُIɊւ炸Aꎞt@C͍폜܂B</para>
        /// <para><see cref="WebResponse"/><see cref="WebResponse.ContentLength"/>ݒ肳ĂȂꍇ
        /// <see cref="Communicator.ProgressChanged"/>Cxg֓nis󋵂̊0ɂȂ܂B</para>
        /// </remarks>
        /// <exception cref="IOException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// _E[hꎞt@C쐬ł܂łB
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// <paramref name="filePath"/>Ŏw肵t@CAǂݎp܂ overwrite  false ̂ߏ㏑ł܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="filePath"/>Ŏw肵t@CpXɖȕ܂܂Ă܂B
        /// </exception>
        /// <exception cref="System.Security.SecurityException">
        /// <paramref name="filePath"/>Ŏw肵t@CpXɕKvȃANZX܂B
        /// </exception>
        /// <exception cref="DirectoryNotFoundException">
        /// <paramref name="filePath"/>Ŏw肵t@CpXA蓖ĂĂȂhCułȂǁAw肳ꂽpXłB
        /// </exception>
        /// <exception cref="UnauthorizedAccessException">
        /// t@C܂̓fBNgǂݎpɐݒ肳ĂȂǁA<paramref name="filePath"/>Ŏw肵t@CpXɑ΂ access vIy[eBO VXeŋ܂B
        /// </exception>
        /// <exception cref="PathTooLongException">
        /// <paramref name="filePath"/>Ŏw肵t@CpXAt@CA܂̗͂VXe`̍ő咷𒴂Ă܂BƂ΁AWindows x[X̃vbgtH[̏ꍇApX̒ 248 At@C̒ 260 łKv܂B
        /// </exception>
        protected virtual void ReceiveBinary(WebResponse response, string filePath)
        {

            string tempFilePath = Path.GetTempFileName();
            try
            {
                // X|XoCif[^̓ǂݍݏ
                using (Stream resStream = response.GetResponseStream())
                {
                    // ꎞt@C̏ݏ
                    using (Stream downFileStream = new FileStream(tempFilePath, FileMode.Create, FileAccess.Write))
                    {
                        int receiveSize = 0;
                        int percentage = 0;
                        long totalSize = response.ContentLength;

                        byte[] buffer = new byte[BufferSize];
                        int bufferSize = resStream.Read(buffer, 0, BufferSize);
                        while (bufferSize > 0)
                        {
                            // t@C
                            downFileStream.Write(buffer, 0, bufferSize);

                            // Cxgʒm
                            receiveSize += bufferSize;
                            if (totalSize > 0)
                            {
                                percentage = (int)(receiveSize * 50 / totalSize) + 50;
                            }
                            OnProgressChanged(new ExecuteProgressChangedEventArgs(percentage));

                            bufferSize = resStream.Read(buffer, 0, BufferSize);
                        }
                    }
                }

                // ꎞt@C̈ړ
                File.Copy(tempFilePath, filePath, true);
 
            }
            finally
            {
                // ꎞt@C폜it@CȂĂAO̓X[Ȃj
                File.Delete(tempFilePath);
            }
        }
        
    }
}
