/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich;

import javax.servlet.ServletContext;

import jp.terasoluna.fw.web.rich.exception.ForbiddenURIException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockFilterConfig;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.utlib.spring.SpringTestCase;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.web.context.WebApplicationContext;

/**
 * {@link jp.terasoluna.fw.web.rich.ForbiddenURIFilter} 
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ĂURIȊOւ̃ANZX֎~tB^B<br>
 * init\bhAdoFilter\bḧnot nullƂB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.rich.ForbiddenURIFilter
 */
public class ForbiddenURIFilterTest extends SpringTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ForbiddenURIFilterTest.class);
    }
    
    @Override
    protected void doOnSetUp() throws Exception {
        LogUTUtil.flush();
    }

    @Override
    protected String[] getConfigLocations() {
        return new String[] {
            "jp/terasoluna/fw/web/rich/ForbiddenURIFilterTest.xml" 
        };
    }

    /**
     * testInit01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() context.getBean("forbiddenURIChecker"):ForbiddenCheckerCX^X<br>
     *         () config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID):null<br>
     *         
     * <br>
     * ҒlF(ԕω) checker:getBean̖߂lƓ̃CX^X<br>
     *         
     * <br>
     * getBean̖߂l𐳏ɑɐݒ肷邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit01() throws Exception {
        // O
        // ForbiddenURIFilter
        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // FilterConfig
        MockFilterConfig config = new MockFilterConfig();
        
        // config.servletContext : this
        ServletContext context = this.servletContext;
        
        // getBeanForbiddenURICheckerNX̃CX^XԂ
        // WebApplicationContextNX
        WebApplicationContextImpl01 webContext =
            new WebApplicationContextImpl01();
        
        // ForbiddenURICheckerNX
        ForbiddenURIFilter_ForbiddenURICheckerStub01 checker =
            new ForbiddenURIFilter_ForbiddenURICheckerStub01();
        UTUtil.setPrivateField(webContext, "checker", checker);
        
        context.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, webContext); 
        
        config.setServletContext(context);
        
        // config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID) : null
        config.setInitParameter("checkerBeanID", null);
                
        // eXg{
        filter.init(config);
        
        // 
        // getBean̖߂lƓ̃CX^X
        assertSame(checker, UTUtil.getPrivateField(filter, "checker"));
        
        // ĂяomF
        // name
        assertEquals("forbiddenURIChecker", webContext.name);
        
        // requiredType : \[XR[hłׂĂ̂ŃeXg̈Ӗ͂Ȃ
        assertEquals(ForbiddenURIChecker.class, webContext.requiredType);
    }

    /**
     * testInit02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() context.getBean("forbiddenURIChecker"):ForbiddenCheckerȊÕCX^X<br>
     *         () config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID):null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:BeanNotOfRequiredTypeException<br>
     *         (ԕω) O:G[x<br>
     *                    the bean is not of the required type - ForbiddenURIChecker.<br>
     *         
     * <br>
     * getBean̖߂lzǑ^ꍇABeanNotOfRequiredTypeExceptionX[邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit02() throws Exception {
        // O
        // ForbiddenURIFilter
        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // FilterConfig
        MockFilterConfig config = new MockFilterConfig();
        
        // config.servletContext : this
        ServletContext context = this.servletContext;
        
        // getBeanBeanNotOfRequiredTypeExceptionON
        // WebApplicationContextNX
        WebApplicationContextImpl02 webContext =
            new WebApplicationContextImpl02();
        
        context.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, webContext);
        
        config.setServletContext(context);
        
        // config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID) : null
        config.setInitParameter("checkerBeanID", null);
        
        
        try {
            // eXg{
            filter.init(config);
            fail();
        } catch (BeanNotOfRequiredTypeException e) {
            // 
            // log : error
            assertTrue(LogUTUtil.checkError("the bean is not of the required type - ForbiddenURIChecker."));
            
            // name
            assertEquals("forbiddenURIChecker", webContext.name);
            
            // requiredType : \[XR[hłׂĂ̂ŃeXg̈Ӗ͂Ȃ
            assertEquals(ForbiddenURIChecker.class, webContext.requiredType);
        }
    }

    /**
     * testInit03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() context.getBean("forbiddenURIChecker"):null<br>
     *         () config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID):null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NoSuchBeanDefinitionException<br>
     *         (ԕω) O:G[x<br>
     *                    there's no such bean definition. BeanID=checkerBeanID.<br>
     *         
     * <br>
     * getBeanŎ擾łȂꍇANoSuchBeanDefinitionExceptionX[邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit03() throws Exception {
        // O
        // ForbiddenURIFilter
        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // FilterConfig
        MockFilterConfig config = new MockFilterConfig();
        
        // config.servletContext : this
        ServletContext context = this.servletContext;
        
        // getBeanNoSuchBeanDefinitionExceptionON
        // WebApplicationContextNX
        WebApplicationContextImpl03 webContext =
            new WebApplicationContextImpl03();
        
        context.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, webContext);
        
        config.setServletContext(context);
        
        // config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID) : null        
        config.setInitParameter("checkerBeanID", null);
        
        
        try {
            // eXg{
            filter.init(config);
            fail();
        } catch (NoSuchBeanDefinitionException e) {
            // 
            // log : error
            assertTrue(LogUTUtil.checkError("there's no such bean definition. BeanID=forbiddenURIChecker."));
            
            // name
            assertEquals("forbiddenURIChecker", webContext.name);
            
            // requiredType : \[XR[hłׂĂ̂ŃeXg̈Ӗ͂Ȃ
            assertEquals(ForbiddenURIChecker.class, webContext.requiredType);
        }
    }

    /**
     * testInit04()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() context.getBean("forbiddenURIChecker"):łȂCX^X<br>
     *         () config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID):null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:BeansException<br>
     *         (ԕω) O:G[x<br>
     *                    the bean could not be created. BeanID=checkerBeanID.<br>
     *         
     * <br>
     * getBeanŃCX^XłȂꍇABeansExceptionX[邱
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit04() throws Exception {
        // O
        // ForbiddenURIFilter
        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // FilterConfig
        MockFilterConfig config = new MockFilterConfig();
        
        // config.servletContext : this
        ServletContext context = this.servletContext;
        
        // getBeanNoSuchBeanDefinitionExceptionON
        // WebApplicationContextNX
        WebApplicationContextImpl04 webContext =
            new WebApplicationContextImpl04();
        
        context.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, webContext);
        
        config.setServletContext(context);
        
        // config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID) : null
        config.setInitParameter("checkerBeanID", null);
        
        
        try {
            // eXg{
            filter.init(config);
            fail();
        } catch (BeansException e) {
            // 
            // log : error
            assertTrue(LogUTUtil.checkError("the bean could not be created. BeanID=forbiddenURIChecker."));
            
            // name
            assertEquals("forbiddenURIChecker", webContext.name);
            
            // requiredType : \[XR[hłׂĂ̂ŃeXg̈Ӗ͂Ȃ
            assertEquals(ForbiddenURIChecker.class, webContext.requiredType);
            
            // OފmFF
            // BeansExceptionOForbiddenURIFilter_BeansExceptionStub01
            assertEquals(
                    ForbiddenURIFilter_BeansExceptionStub01.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testInit05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() context.getBean("ABC"):ForbiddenCheckerCX^X<br>
     *         () config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID):"ABC"<br>
     *         
     * <br>
     * ҒlF(ԕω) checker:getBean̖߂lƓ̃CX^X<br>
     *         
     * <br>
     * getBean̖߂l𐳏ɑɐݒ肷邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testInit05() throws Exception {
        // O
        // ForbiddenURIFilter
        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // FilterConfig
        MockFilterConfig config = new MockFilterConfig();
        
        // config.servletContext : this
        ServletContext context = this.servletContext;
        
        // getBeanForbiddenURICheckerNX̃CX^XԂ
        // WebApplicationContextNX
        WebApplicationContextImpl01 webContext =
            new WebApplicationContextImpl01();
        
        // ForbiddenURICheckerNX
        ForbiddenURIFilter_ForbiddenURICheckerStub01 checker =
            new ForbiddenURIFilter_ForbiddenURICheckerStub01();
        UTUtil.setPrivateField(webContext, "checker", checker);
        
        context.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, webContext);
        
        config.setServletContext(context);
        
        // config.getInitParameter(INITPARAM_KEY_CHECKER_BEANID) : "ABC"
        config.setInitParameter("checkerBeanID", "ABC");
        
        
        // eXg{
        filter.init(config);

        
        // 
        // getBean̖߂lƓ̃CX^X
        assertSame(checker, UTUtil.getPrivateField(filter, "checker"));
        
        // name : "ABC"
        assertEquals("ABC", webContext.name);
        
        // requiredType : \[XR[hłׂĂ̂ŃeXg̈Ӗ͂Ȃ
        assertEquals(ForbiddenURIChecker.class, webContext.requiredType);
    }

    /**
     * testDoFilter01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:HTTPNGXg<br>
     *         () req.getRequestURI():/sample2/secure/blogic.do<br>
     *         () req.getContextPath():/sample2<br>
     *         () res:HTTPX|X<br>
     *         () chain:tB^`FC<br>
     *         () checker.isAllowedURI():true<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * checker.isAllowedURI()truȅꍇAOɏI邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter01() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        FilterChainImpl01 chain = new FilterChainImpl01();
        
        // requestURI : "/sample2/secure/blogic.do"
        req.setRequestURI("/sample2/secure/blogic.do");
        // contextPath : "/sample2"
        req.setContextPath("/sample2");

        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // checker.isAllowedURI() : true
        ForbiddenURIFilter_ForbiddenURICheckerStub01 checker =
            new ForbiddenURIFilter_ForbiddenURICheckerStub01();
        checker.isAllowed = true;
        UTUtil.setPrivateField(filter, "checker", checker);

        // eXg{
        filter.doFilter(req, res, chain);

        // 
        assertTrue(chain.isDoFilter);
    }

    /**
     * testDoFilter02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() req:HTTPNGXg<br>
     *         () req.getRequestURI():/sample2/secure/blogic.do<br>
     *         () req.getContextPath():/sample2<br>
     *         () res:HTTPX|X<br>
     *         () chain:tB^`FC<br>
     *         () checker.isAllowedURI():false<br>
     *         
     * <br>
     * ҒlF(ԕω) O:ForbiddenURIExceptionX[<br>
     *         (ԕω) O:request url is forbidden!<br>
     *         
     * <br>
     * checker.isAllowedURI()falsȅꍇAForbiddenURIExceptionX[
     * Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter02() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        FilterChainImpl01 chain = new FilterChainImpl01();
        
        // requestURI : "/sample2/secure/blogic.do"
        req.setRequestURI("/sample2/secure/blogic.do");
        // contextPath : "/sample2"
        req.setContextPath("/sample2");

        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // checker.isAllowedURI() : false
        ForbiddenURIFilter_ForbiddenURICheckerStub01 checker =
            new ForbiddenURIFilter_ForbiddenURICheckerStub01();
        checker.isAllowed = false;
        UTUtil.setPrivateField(filter, "checker", checker);

        try {
            // eXg{
            filter.doFilter(req, res, chain);
            fail();
        } catch (ForbiddenURIException e) {
            // 
            assertTrue(LogUTUtil.checkError("request url is forbidden!"));
            assertFalse(chain.isDoFilter);
        }
    }

    /**
     * testDoFilter03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:HTTPNGXg<br>
     *         () req.getRequestURI():󕶎<br>
     *         () req.getContextPath():󕶎<br>
     *         () res:HTTPX|X<br>
     *         () chain:tB^`FC<br>
     *         () checker.isAllowedURI():true<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * HTTPNGXgɐݒ肳ĂURI󕶎ŁAtB^ݒ̋URI
     * 󕶎̏ꍇłAchecker.isAllowedURI()truȅꍇAO
     * I邱Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter03() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        FilterChainImpl01 chain = new FilterChainImpl01();
        
        // requestURI : 󕶎
        req.setRequestURI("");
        // contextPath : 󕶎
        req.setContextPath("");

        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // checker.isAllowedURI() : true
        ForbiddenURIFilter_ForbiddenURICheckerStub01 checker =
            new ForbiddenURIFilter_ForbiddenURICheckerStub01();
        checker.isAllowed = true;
        UTUtil.setPrivateField(filter, "checker", checker);

        // eXg{
        filter.doFilter(req, res, chain);

        // 
        assertTrue(chain.isDoFilter);
    }

    /**
     * testDoFilter04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() req:HTTPNGXg<br>
     *         () req.getRequestURI():/sample2<br>
     *         () req.getContextPath():/sample2<br>
     *         () res:HTTPX|X<br>
     *         () chain:tB^`FC<br>
     *         () checker.isAllowedURI():true<br>
     *         
     * <br>
     * ҒlF
     * <br>
     * HTTPNGXgɐݒ肳ĂURIƃReLXg̕񒷂ꍇ
     * łAchecker.isAllowedURI()truȅꍇAOɏI
     * Ƃ̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoFilter04() throws Exception {
        // O
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        FilterChainImpl01 chain = new FilterChainImpl01();
        
        // requestURI : "/sample2"
        req.setRequestURI("/sample2");
        // contextPath : "/sample2"
        req.setContextPath("/sample2");

        ForbiddenURIFilter filter = new ForbiddenURIFilter();
        
        // checker.isAllowedURI() : true
        ForbiddenURIFilter_ForbiddenURICheckerStub01 checker =
            new ForbiddenURIFilter_ForbiddenURICheckerStub01();
        checker.isAllowed = true;
        UTUtil.setPrivateField(filter, "checker", checker);

        // eXg{
        filter.doFilter(req, res, chain);

        // 
        assertTrue(chain.isDoFilter);
    }
}