/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;

import jp.terasoluna.fw.file.dao.FileException;

/**
 * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
 * 
 *
 */
public class LineFeed1LineReader implements LineReader {

    /**
     * t@CANZXp̕Xg[B
     */
    private Reader reader;
    
    /**
     * s؂蕶B
     */
    private String lineFeedChar;
    
    /**
     * RXgN^B
     * @param reader t@CANZXp̕Xg[
     * @param lineFeedChar s؂蕶
     */
    public LineFeed1LineReader(Reader reader, String lineFeedChar) {
        this.reader = reader;
        this.lineFeedChar = lineFeedChar;
    }

    /**
     * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
     * @return f[^̂Ps̕
     */
    public String readLine() {
        StringBuilder currentLineString = new StringBuilder();

        try {
            while (reader.ready()) {
                char currentChar = (char) reader.read();
                if (currentChar == lineFeedChar.charAt(0)) {
                    break;
                }
                currentLineString.append(currentChar);
            }
        } catch (IOException e) {
            throw new FileException(e);
        }
        
        return currentLineString.toString();
    }

}
