/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao;

/**
 * t@CANZX@\ŔObvNXB
 * <p>
 * t@Cs̃f[^ǂݎۂɔObvNXB
 * </p>
 */
public class FileLineException extends FileException {

    /**
     * VAo[WUIDB
     */
    private static final long serialVersionUID = 3669406429664627698L;

    /**
     * G[JB
     */
    private final String columnName;

    /**
     * G[JԍB
     */
    private final int columnIndex;

    /**
     * G[s̍sԍB
     */
    private final int lineNo;
    
    /**
     * RXgN^B
     * @param e O
     */
    public FileLineException(Exception e) {
        super(e);
        columnName = null;
        columnIndex = -1;
        lineNo = -1;
    }
    
    /**
     * RXgN^B
     * @param message bZ[W
     */
    public FileLineException(String message) {
        super(message);
        columnName = null;
        columnIndex = -1;
        lineNo = -1;
    }
    
    /**
     * RXgN^B
     * @param message bZ[W
     * @param e O
     */
    public FileLineException(String message, Exception e) {
        super(message, e);
        columnName = null;
        columnIndex = -1;
        lineNo = -1;
    }
    
    /**
     * RXgN^B
     * @param e O
     * @param fileName t@C
     * @param lineNo G[s̍sԍ
     */
    public FileLineException(Exception e, String fileName, int lineNo) {
        super(e, fileName);
        this.lineNo = lineNo;
        columnName = null;
        columnIndex = -1;
    }

    /**
     * RXgN^B
     * @param e O
     * @param fileName t@C
     * @param lineNo G[s̍sԍ
     * @param columnName J
     * @param columnIndex G[Jԍ
     */
    public FileLineException(Exception e, String fileName, int lineNo, String columnName, int columnIndex) {
        super(e, fileName);
        this.columnName = columnName;
        this.columnIndex = columnIndex;
        this.lineNo = lineNo;
    }
    
    /**
     * RXgN^B
     * @param message bZ[W
     * @param e O
     * @param fileName t@C
     * @param lineNo G[s̍sԍ
     * @param columnName J
     * @param columnIndex G[Jԍ
     */
    public FileLineException(String message, Exception e, String fileName, int lineNo, String columnName, int columnIndex) {
        super(message, e, fileName);
        this.columnName = columnName;
        this.columnIndex = columnIndex;
        this.lineNo = lineNo;
    }


    /**
     * J擾B
     * @return J
     */
    public String getColumnName() {
        return this.columnName;
    }

    /**
     * G[s̍sԍ擾B
     * @return G[s̍sԍ
     */
    public int getLineNo() {
        return this.lineNo;
    }

    /**
     * G[J̃Jԍ擾B
     * @return G[J̃Jԍi0Jnj
     */
    public int getColumnIndex() {
        return columnIndex;
    }
    
    

}
