/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.springsupport.transaction;

import java.util.LinkedHashMap;
import java.util.List;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.standard.StandardBLogicResultHandler;

/**
 * gUNVs <code>BLogicResultHandler</code> C^tF[X
 * NXB
 * 
 * <p><code>BLogicResult</code> ̃^[R[hɉāAgUNV
 * iR~bgA[obNjsBgUNVԂ́A
 * <code>{@link TransactionalJobStatus}<code> ɕێĂB</p>
 * 
 * <p><strong>Z[u|Cg𗘗pĂꍇ</strong></p>
 * 
 * <p><code>BLogicResult</code> ̃^[R[hƂ <code>NORMAL_CONTINUE
 * </code> Ԃ閈ɁAZ[u|CgA쐬B</p>
 * 
 * <p><code>BLogicResult</code> ̃^[R[hƂ <code>ERROR_CONTINUE
 * </code>A܂<code>ERROR_END</code> Ԃꂽꍇɂ́AZ[u|Cg܂
 * gUNV[obNB</p>
 * 
 * <p><strong>Z[u|Cg𗘗pĂȂꍇ</strong></p>
 * 
 * <p><code>BLogicResult</code> ̃^[R[hƂ <code>NORMAL_CONTINUE
 * </code>A邢<code>ERROR_CONTINUE</code> Ԃꂽꍇɂ́AgUNV
 * Ɋւ鏈͎sȂB</p>
 * 
 * <p><code>BLogicResult</code> ̃^[R[hƂ <code>ERROR_END</code> 
 * Ԃꂽꍇɂ́As̃gUNV[obNB</p>
 * 
 */
public class TransactionalBLogicResultHandler 
    extends StandardBLogicResultHandler {

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>NORMAL_CONTINUE</code>
     *  łƂ̏sB
     * 
     * <p>Z[u|Cg𗘗pĂꍇɂ̓Z[u|Cg쐬AeN
     * X̏ĂяoB</p>
     *
     * @param jobStatus WuXe[^X
     * @param blogicResult rWlXWbN
     * @param batchUpdateMapList ob`XVXg
     */
    @Override
    protected void processNormalContinue(JobStatus jobStatus, 
            BLogicResult blogicResult, List<LinkedHashMap<String, 
            Object>> batchUpdateMapList) {
        TransactionalJobStatus transactionalJobStatus = 
            (TransactionalJobStatus) jobStatus;

        // Z[u|Cg̉A쐬
        if (transactionalJobStatus.useSavepoint()) {
            transactionalJobStatus.releaseAndCreateSavepoint();
        }
        
        super.processNormalContinue(jobStatus, blogicResult,
                batchUpdateMapList);
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>ERROR_CONTINUE</code> 
     * łƂ̏sB
     *
     * <p>Z[u|Cg𗘗pĂꍇɂ̓Z[u|Cg܂ŃgUNV
     * [obNAeNX̏ĂяoB</p>
     *
     * @param blogicInputData rWlXWbN̓̓f[^
     * @param jobStatus WuXe[^X
     * @param blogicResult rWlXWbN
     */
    @Override
    protected void processErrorContinue(Object blogicInputData,
            JobStatus jobStatus, BLogicResult blogicResult) {
        TransactionalJobStatus transactionalJobStatus = 
            (TransactionalJobStatus) jobStatus;
        // [obN
        if (transactionalJobStatus.useSavepoint()) {
            transactionalJobStatus.rollbackToSavepoint();
        }
        
        super.processErrorContinue(blogicInputData, jobStatus, blogicResult);
    }

    /**
     * <code>BLogicResult</code> ̃^[R[h <code>ERROR_END</code> 
     * Ƃ̏sB
     *
     * <p>Z[u|Cg𗘗pĂꍇɂ̓Z[u|Cg܂ŃgUNV
     * [obNAeNX̏ĂяoB</p>
     * 
     * <p>Z[u|Cg𗘗pĂȂꍇɂ̓gUNV[obNA
     * eNX̏ĂяoB</p>
     *
     * @param blogicInputData rWlXWbN̓̓f[^
     * @param jobStatus WuXe[^X
     * @param blogicResult rWlXWbN
     */
    @Override
    protected void processErrorEnd(Object blogicInputData,
            JobStatus jobStatus, BLogicResult blogicResult) {
        TransactionalJobStatus transactionalJobStatus = 
            (TransactionalJobStatus) jobStatus;
        // [obN
        if (transactionalJobStatus.useSavepoint()) {
            transactionalJobStatus.rollbackToSavepoint();
        } else {
            transactionalJobStatus.rollback();
        }
    
        super.processErrorEnd(blogicInputData, jobStatus, blogicResult);
    }
}
