/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus;

public class TransactionalSupportProcessor
implements SupportProcessor {
    private SupportProcessor supportProcessor = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(JobContext jobContext, JobStatus jobStatus) {
        if (this.supportProcessor.canSkip()) {
            return;
        }
        TransactionalJobStatus transactionalJobStatus = (TransactionalJobStatus)jobStatus;
        transactionalJobStatus.beginTransaction();
        boolean commitFlag = false;
        try {
            this.supportProcessor.process(jobContext, jobStatus);
            commitFlag = true;
        }
        finally {
            if (commitFlag && (jobStatus.isExecuting() || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY || jobStatus.isShutdownGraceful())) {
                transactionalJobStatus.commit();
            } else {
                transactionalJobStatus.rollback();
            }
        }
        if (jobStatus.isShutdownGraceful()) {
            jobStatus.suspend();
        }
    }

    public void setSupportProcessor(SupportProcessor supportProcessor) {
        this.supportProcessor = supportProcessor;
    }

    public boolean canSkip() {
        return this.supportProcessor.canSkip();
    }
}

