/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.springsupport.transaction;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.springsupport.transaction.TransactionalJobStatus;
import jp.terasoluna.fw.batch.standard.QueueProcessor;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

public class TransactionalQueueProcessor
extends QueueProcessor {
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(WorkQueue workQueue, JobStatus jobStatus) {
        TransactionalJobStatus transactionalJobStatus = (TransactionalJobStatus)jobStatus;
        transactionalJobStatus.beginTransaction();
        boolean commitFlag = false;
        try {
            super.process(workQueue, jobStatus);
            commitFlag = true;
        }
        catch (QueueingException e) {
            if (jobStatus.getJobState() == JobStatus.STATE.SUSPENDING) {
                return;
            }
            throw e;
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(null, throwable, jobStatus);
        }
        finally {
            if (commitFlag && (jobStatus.isExecuting() || jobStatus.getJobState() == JobStatus.STATE.ENDING_NORMALLY || jobStatus.isShutdownGraceful())) {
                transactionalJobStatus.commit();
            } else {
                transactionalJobStatus.rollback();
            }
        }
        if (jobStatus.isShutdownGraceful()) {
            jobStatus.suspend();
        }
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

