// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.Sql
{
    /// <summary>
    /// SQL ݒt@C SqlConfiguration ݒ擾܂B
    /// </summary>
    public abstract class SqlConfiguration
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(SqlConfiguration));

        /// <summary>
        /// SQL 擾܂B
        /// </summary>
        /// <param name="name">擾 SQL ̎ʎqB</param>
        /// <returns>ʎqɑΉ SQL B</returns>
        /// <remarks>
        /// SQL ݒt@CAname ̒lɑΉ SQL 擾܂B
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="name"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="name"/> 󕶎łB
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@CǂݍނƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="name"/> ̒lɑΉ SQL ݂ȂꍇB
        /// </item>
        /// </list>
        /// </exception>
        public static string GetSql(string name)
        {
            if (name == null)
            {
                ArgumentNullException exception = new ArgumentNullException("name");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "name"), exception);
                }
                throw exception;
            }
            if (name.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "name");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            SqlElement sqlElement = TerasolunaWebConfiguration.SqlConfigSection.Sqls[name];

            if (sqlElement == null)
            {
                string message = string.Format(Properties.Resources.E_SQL_STATEMENT_NOT_FOUND, name);
                ConfigurationErrorsException exception = new ConfigurationErrorsException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            if (_log.IsTraceEnabled)
            {
                _log.Trace(string.Format(Properties.Resources.T_SQL_CONFIGURATION_LOAD_SQL, name, sqlElement.Statement));
            }

            return sqlElement.Statement;
        }
    }
}
