﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.BLogic;
using System.Data;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
namespace TERASOLUNA.Fw.CommonUT
{
    /// <summary>
    /// BLogicParam のテストクラスです。
    ///</summary>
    [TestClass()]
    public class BLogicParamTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///BLogicParam (DataSet) のテスト
        ///</summary>
        [TestMethod()]
        public void ConstructorTest()
        {
            //準備
            DataSet paramData = new DataSet();

            //実行
            BLogicParam target = new BLogicParam(paramData);

            //確認
            Assert.AreSame(paramData, target.ParamData);
            Assert.AreEqual(0, target.Items.Count);
        }

        /// <summary>
        /// Items のテスト
        ///</summary>
        ///<remarks>
        /// Itemsが返却されることを確認するテスト
        /// </remarks>
        [TestMethod()]
        public void ItemsTest()
        {
            //準備
            BLogicParam target = new BLogicParam();
            IDictionary<string, object> val = new Dictionary<string, object>();
            TERASOLUNA_Fw_Common_BLogic_BLogicParamAccessor accessor = new TERASOLUNA_Fw_Common_BLogic_BLogicParamAccessor(target);
            //実行
            accessor._items = val;
            IDictionary<string, object> actualItems = target.Items;
            //検証
            Assert.AreSame(val, actualItems);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicParam), LogLevel.INFO));
        }

        /// <summary>
        /// ParamData のテスト
        ///</summary>
        ///<remarks>
        /// ParamDataが返却されることを確認するテスト
        /// </remarks>
        [TestMethod()]
        public void ParamDataTest()
        {
            //準備
            BLogicParam target = new BLogicParam();
            DataSet expectedParamData = new DataSet(); 
            //実行
            target.ParamData = expectedParamData;
            DataSet actualParamData = target.ParamData; 
            //検証
            Assert.AreEqual(expectedParamData, actualParamData);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicParam), LogLevel.INFO));
        }
    }
}
