// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using Microsoft.Practices.EnterpriseLibrary.Common.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Validators;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Common.Validation.Configuration;

namespace TERASOLUNA.Fw.Common.Validation.Validators
{

    /// <summary>
    /// ؃["K{`FbN"ɑΉK{`FbNs <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> pNXłB
    /// </summary>
    /// <remarks>
    /// <para>
    /// ؑΏۂ̒l\łA
    /// ؑΏە񂪁Aw肵܂ł邩̃`FbN錟؋@\񋟂܂B
    ///  null ܂͋󕶎ɑ΂Ă͌؂͍sȂ߁A <see cref="ValueValidator.Negated"/> ̏ԂɊւ炸AKؐƂȂ܂B 
    /// </para>
    /// <para>
    /// {NXpē͒l؂{ɂ́A͒lؐݒt@CɋLq
    ///  validator vf̑ƂāAȉ̐ݒs܂B
    /// ͒lؐݒt@Ĉ̋L@ɂẮA
    ///  Validation Application Block ̃hLgQƂĂB 
    /// </para>
    /// <para>
    /// <list type="bullet">
    /// <item>
    /// <description>negated</description>
    /// <para>؃[𔽓]tOłB true ݒ肵ꍇA؃[]܂BftHgĺA false łB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplate</description>
    /// <para>؃G[bZ[W̃ev[gƂĎgp镶B
    /// ݒ̏ꍇ́A <seealso cref="NumericStringValidator.DefaultNonNegatedMessageTemplate"/> A <seealso cref="NumericStringValidator.DefaultNegatedMessageTemplate"/>  
    /// ꂩgp܂B
    /// </para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceName</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̖OB</para>
    /// </item>
    /// <item>
    /// <description>messageTemplateResourceType</description>
    /// <para>bZ[Wev[g\[Xǂݍލۂ̃\[X̌^B</para>
    /// </item>
    /// <item>
    /// <description>tag</description>
    /// <para>bZ[Wev[g̃v[Xz_{2}ɓn镶B
    /// ؑΏۍڂ̘_w肵܂B</para>
    /// </item>
    /// <item>
    /// <description>type</description>
    /// <para>gpValidatorNX̌^SC^Ŏw肵܂B</para>
    /// </item>
    /// <item>
    /// <description>name</description>
    /// <para>gp <see cref="Microsoft.Practices.EnterpriseLibrary.Validation.Validator"/> ɖO܂BɗpȂlłB 
    /// Cӂ̖O邱Ƃł܂ǍؑΏۂ̏ꍇA̖O邱Ƃ͋܂B
    /// ܂A󕶎܂BK{łB</para>
    /// </item>
    /// <item>
    /// <description>characterSet</description>
    /// <para>`FbNΏۂ̕B</para>
    /// </item>
    /// <item>
    /// <description>containsCharacter</description>
    /// <para>̃`FbNłB</para>
    /// </item>
    /// </list>
    /// </para>
    /// <example>
    /// <code>
    /// &lt;validator characterSet="qwerty" containsCharacter="All" negated="true"
    /// messageTemplate="" messageTemplateResourceName="" messageTemplateResourceType=""  tag=""
    /// type="TERASOLUNA.FW.Common.Validation.Validators. ContainsCharactersValidatorEx,TERASOLUNA.FW.Common.Validation"
    /// name="Contains Characters Ex Validator" /&gt;
    /// </code>
    /// </example>
    /// </remarks>
    [ConfigurationElementType(typeof(ContainsCharactersValidatorExData))]
    public class ContainsCharactersValidatorEx : ContainsCharactersValidator
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ContainsCharactersValidatorEx));

        /// <summary>
        /// ؂̐U镑ێ <see cref="ContainsCharacters"/>NX̃CX^XB
        /// </summary>
        private ContainsCharacters _containsCharacters = ContainsCharacters.Any;

        /// <summary>
        /// <see cref="ContainsCharactersValidatorEx"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="characterSet">`FbNΏۂ̕B</param>
        /// <param name="containsCharacters">̃`FbNB</param>
        /// <param name="messageTemplate">؃G[bZ[W̃ev[gƂĎgp镶B
        /// ؂ɗpp[^v[Xz_ɓn܂B
        /// p[^Ƃ̃v[Xz_ԍ͈ȉ̒ʂłB
        /// <list type="table">
        /// <listheader>
        /// <term>v[Xz_</term>
        /// <description>e</description>
        /// </listheader>
        /// <item>
        /// <term>{0}</term>
        /// <description>ؑΏە</description>
        /// </item>
        /// <item>
        /// <term>{1}</term>
        /// <description>key(vpeBE\bh)</description>
        /// </item>
        /// <item>
        /// <term>{2}</term>
        /// <description>Tag</description>
        /// </item>
        /// <item>
        /// <term>{3}</term>
        /// <description>`FbNΏۂ̕</description>
        /// </item>
        /// <item>
        /// <term>{4}</term>
        /// <description>̃`FbN</description>
        /// </item>
        /// </list>
        /// </param>
        /// <param name="negated">؃[𔽓]tOB</param>
        public ContainsCharactersValidatorEx(string characterSet, ContainsCharacters containsCharacters, string messageTemplate, bool negated)
            : base(characterSet, containsCharacters, messageTemplate, negated)
        {
            _containsCharacters = containsCharacters;
        }

        /// <summary>
        /// 񑶍݃`FbNValidatorŗpA
        /// <seealso cref="ValueValidator.Negated"/>  true łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>؃[]̃ftHgbZ[Wev[gB</value>
        protected override string DefaultNegatedMessageTemplate
        {
            get
            {
                if (_containsCharacters == ContainsCharacters.All)
                {
                    return Properties.Resources.CONTAINS_VALIDATOR_ALL_NEGATED_MESSAGETEMPLATE;
                }
                else
                {
                    return Properties.Resources.CONTAINS_VALIDATOR_ANY_NEGATED_MESSAGETEMPLATE;
                }
            }
        }

        /// <summary>
        /// 񑶍݃`FbNValidatorŗpA
        /// <seealso cref="ValueValidator.Negated"/>  false łꍇɎgpftHg̃bZ[Wev[g擾܂B
        /// </summary>
        /// <value>ftHgbZ[Wev[gB</value>
        protected override string DefaultNonNegatedMessageTemplate
        {
            get
            {
                if (_containsCharacters == ContainsCharacters.All)
                {
                    return Properties.Resources.CONTAINS_VALIDATOR_ALL_NONNEGATED_MESSAGETEMPLATE;
                }
                else
                {
                    return Properties.Resources.CONTAINS_VALIDATOR_ANY_NONNEGATED_MESSAGETEMPLATE;
                }
            }
        }

        /// <summary>
        /// K{`FbNs\bhłB
        /// ؑΏە񂪁Aw肵܂ł邩̃`FbN܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="objectToValidate"/>  null ܂͋󕶎̏ꍇA
        /// ؏͍sꂸA،ʂ͕KƂȂ܂B
        /// negatedtruȅꍇA؏]܂B
        /// </para>
        /// </remarks>
        /// <param name="objectToValidate">ؑΏۂ̒lB</param>
        /// <param name="currentTarget">ؑΏۂ̃IuWFNgB</param>
        /// <param name="key">ؑΏۂ̃vpeB܂̓\bhB</param>
        /// <param name="validationResults">،ʂi[ <see cref="ValidationResults"/> B</param>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="validationResults"/>  null QƂłB
        /// </exception> 
        protected override void DoValidate(string objectToValidate, object currentTarget, string key, ValidationResults validationResults)
        {
            if (validationResults == null)
            {
                ArgumentNullException exception = new ArgumentNullException("validationResults");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "validationResults"), exception);
                }
                throw exception;
            }

            if (string.IsNullOrEmpty(objectToValidate))
            {
                return;
            }

            base.DoValidate(objectToValidate, currentTarget, key, validationResults);
        }

    }
}
