// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client;
using TERASOLUNA.Fw.Common.Validation;
using System.Data;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.ClientUT.CoordinatorTestData
{
    /// <summary>
    /// Coordinator P̎p EventController hNXłB
    /// </summary>
    /// <remarks>
    /// OCxgɂăG[ 1 
    /// G[̌^ ValidationMessageInfo łȂB
    /// </remarks>
    public class Coordinator_EventControllerStub08 : EventController
    {
        // ReportCustomValidating() ̌ĂяomFp
        private bool _isCalledReportCustomValidating = false;
        private ValidationResult _reportCustomValidatingValidationResult = null;

        // ReportValidationFailed() ̌ĂяomFp
        private bool _isCalledReportValidationFailed = false;
        private ExecutionResult _reportValidationFailedExecutionResult = null;

        // ReportPreprocessed() ̌ĂяomFp
        private bool _isCalledReportPreprocessed = false;
        private ExecutionResult _reportPreprocessedExecutionResult = null;
        private DataSet _reportPreprocessedBlogicParamData = null;
        private MessageInfo _reportPreprocessedMessageInfo01 = null;

        // ReportPreprocessedFailed() ̌ĂяomFp
        private bool _isCalledReportPreprocessedFailed = false;
        private ExecutionResult _reportPreprocessedFailedExecutionResult = null;
        private DataSet _reportPreprocessedFailedBlogicParamData = null;

        // ReportBLogicFailed() ̌ĂяomFp
        private bool _isCalledReportBLogicFailed = false;
        private ExecutionResult _reportBLogicFailedExecutionResult = null;

        // ReportExecuteCompleted() ̌ĂяomFp
        private bool _isCalledReportExecuteCompleted = false;
        private ExecutionResult _reportExecuteCompletedExecutionResult = null;
        private Exception _reportExecuteCompletedError = null;
        private bool _reportExecuteCompletedCancelled = false;

        public bool IsCalledReportCustomValidating
        {
            get { return _isCalledReportCustomValidating; }
        }

        public ValidationResult ReportCustomValidatingValidationResult
        {
            get { return _reportCustomValidatingValidationResult; }
        }

        public bool IsCalledReportValidationFailed
        {
            get { return _isCalledReportValidationFailed; }
        }

        public ExecutionResult ReportValidationFailedExecutionResult
        {
            get { return _reportValidationFailedExecutionResult; }
        }

        public bool IsCalledReportPreprocessed
        {
            get { return _isCalledReportPreprocessed; }
        }

        public ExecutionResult ReportPreprocessedExecutionResult
        {
            get { return _reportPreprocessedExecutionResult; }
        }

        public DataSet ReportPreprocessedBlogicParamData
        {
            get { return _reportPreprocessedBlogicParamData; }
        }

        public MessageInfo ReportPreprocessedMessageInfo01
        {
            get { return _reportPreprocessedMessageInfo01; }
        }

        public bool IsCalledReportPreprocessedFailed
        {
            get { return _isCalledReportPreprocessedFailed; }
        }

        public ExecutionResult ReportPreprocessedFailedExecutionResult
        {
            get { return _reportPreprocessedFailedExecutionResult; }
        }

        public DataSet ReportPreprocessedFailedBlogicParamData
        {
            get { return _reportPreprocessedFailedBlogicParamData; }
        }

        public bool IsCalledReportBLogicFailed
        {
            get { return _isCalledReportBLogicFailed; }
        }

        public ExecutionResult ReportBLogicFailedExecutionResult
        {
            get { return _reportBLogicFailedExecutionResult; }
        }

        public bool IsCalledReportExecuteCompleted
        {
            get { return _isCalledReportExecuteCompleted; }
        }

        public ExecutionResult ReportExecuteCompletedExecutionResult
        {
            get { return _reportExecuteCompletedExecutionResult; }
        }

        public Exception ReportExecuteCompletedError
        {
            get { return _reportExecuteCompletedError; }
        }

        public bool ReportExecuteCompletedCancelled
        {
            get { return _reportExecuteCompletedCancelled; }
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <remarks>
        /// vpeB̏ݒs܂B
        /// </remarks>
        public Coordinator_EventControllerStub08()
        {
            this.ErrorHandler = null;
            this.ErrorPaths.Clear();
            this.ValidationFilePath = null;
            this.RuleSet = null;
            this.BLogicParamTypeName = typeof(Coordinator_DataSetStub01).AssemblyQualifiedName;
            this.Items.Clear();
            this.ConvertId = null;
            this.BLogicResultTypeName = typeof(Coordinator_DataSetStub02).AssemblyQualifiedName;
            this.BLogicName = "blogicName"; ;
            this.ViewData = new Coordinator_DataSetStub03();
            this.RequestName = "requestName";
        }

        // ȉA\bh̃I[o[Ch
        public override void ReportCustomValidating(ValidationResult validationResult)
        {
            _isCalledReportCustomValidating = true;

            ValidationResult result = new ValidationResult();
            foreach (MessageInfo info in validationResult.Errors)
            {
                result.Errors.Add(info);
            }
            _reportCustomValidatingValidationResult = result;
        }

        public override void ReportValidationFailed(ExecutionResult executionResult)
        {
            _isCalledReportValidationFailed = true;
            _reportValidationFailedExecutionResult = Clone(executionResult);
        }

        public override void ReportPreprocessed(ExecutionResult executionResult, DataSet blogicParamData)
        {
            _isCalledReportPreprocessed = true;
            _reportPreprocessedExecutionResult = Clone(executionResult);
            _reportPreprocessedBlogicParamData = blogicParamData;

            executionResult.ResultString = "terasoluna";
        }

        public override void ReportPreprocessedFailed(ExecutionResult executionResult, DataSet blogicParamData)
        {
            _isCalledReportPreprocessedFailed = true;
            _reportPreprocessedFailedExecutionResult = Clone(executionResult);
            _reportPreprocessedFailedBlogicParamData = blogicParamData;
        }

        public override void ReportBLogicFailed(ExecutionResult executionResult)
        {
            _isCalledReportBLogicFailed = true;
            _reportBLogicFailedExecutionResult = Clone(executionResult);
        }

        public override void ReportExecuteCompleted(ExecutionResult executionResult, Exception error, bool cancelled)
        {
            _isCalledReportExecuteCompleted = true;
            _reportExecuteCompletedExecutionResult = executionResult;
            _reportExecuteCompletedError = error;
            _reportExecuteCompletedCancelled = cancelled;
        }

        /// <summary>
        /// œnꂽ ExecutionResult CX^X̃Rs[𐶐ĕԋp܂B
        /// SȃfB[vRs[ł͂܂B
        /// </summary>
        public static ExecutionResult Clone(ExecutionResult executionResult)
        {
            ExecutionResult result = new ExecutionResult();

            if (executionResult.BLogicResultData != null)
            {
                result.BLogicResultData = executionResult.BLogicResultData.Copy();
            }

            if (executionResult.ResultString != null)
            {
                result.ResultString = string.Copy(executionResult.ResultString);
            }

            foreach (MessageInfo messageInfo in executionResult.Errors)
            {
                string key = null;
                string message = null;
                if (messageInfo.Key != null)
                {
                    key = string.Copy(messageInfo.Key);
                }
                if (messageInfo.Message != null)
                {
                    message = string.Copy(messageInfo.Message);
                }
                MessageInfo info = new MessageInfo(key, message);

                // IuWFNg^̂߃fB[vRs[łȂ
                info.Detail = messageInfo.Detail;

                result.Errors.Add(info);
            }
            return result;
        }
    }
}
