// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.Communication;
using System.Runtime.Serialization;
using System.Data;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Utlib.Logging;
using System.Reflection;
namespace TERASOLUNA.Fw.ClientUT.Communication
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Communication.MultipartUploadCommunicator&lt;TResultData&gt; のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Communication.MultipartUploadCommunicator&lt;TResultData&gt; 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class MultipartUploadCommunicatorTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// MultipartUploadCommunicator () のテスト
        /// </summary>
        /// <remarks>
        /// コンストラクタで値が正常に設定されていることを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備
            PropertyInfo senderProperty = typeof(MultipartUploadCommunicator<>).GetProperty("Sender", BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            PropertyInfo receiverProperty = typeof(MultipartUploadCommunicator<>).GetProperty("Receiver", BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);

            // 実施
            MultipartUploadCommunicator<DataSet> target = new MultipartUploadCommunicator<DataSet>();

            // 確認
            MultipartSender actualSender = senderProperty.GetValue(target, null) as MultipartSender;
            DataSetXmlReceiver<DataSet> actualReceiver = receiverProperty.GetValue(target, null) as DataSetXmlReceiver<DataSet>;
            Assert.IsInstanceOfType(actualSender, typeof(MultipartSender));
            Assert.IsInstanceOfType(actualReceiver, typeof(DataSetXmlReceiver<DataSet>));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MultipartUploadCommunicator<>), LogLevel.INFO));
        }

        /// <summary>
        /// MultipartUploadCommunicator () のテスト
        /// </summary>
        /// <remarks>
        /// 引数 checkBoundaryFlag が false の場合、
        /// 正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorBoolTest01()
        {
            // 準備
            PropertyInfo senderProperty = typeof(MultipartUploadCommunicator<DataSet>).GetProperty("Sender", BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            PropertyInfo receiverProperty = typeof(MultipartUploadCommunicator<DataSet>).GetProperty("Receiver", BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            bool expectedCheckBoundaryFlag = false;

            // 実施
            MultipartUploadCommunicator<DataSet> target = new MultipartUploadCommunicator<DataSet>(expectedCheckBoundaryFlag);

            // 確認
            MultipartSender actualSender = senderProperty.GetValue(target, null) as MultipartSender;
            DataSetXmlReceiver<DataSet> actualReceiver = receiverProperty.GetValue(target, null) as DataSetXmlReceiver<DataSet>;
            Assert.IsInstanceOfType(actualSender, typeof(MultipartSender));
            Assert.IsFalse(actualSender.CheckBoundary);
            Assert.IsInstanceOfType(actualReceiver, typeof(DataSetXmlReceiver<DataSet>));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MultipartUploadCommunicator<>), LogLevel.INFO));
        }

        /// <summary>
        /// MultipartUploadCommunicator () のテスト
        /// </summary>
        /// <remarks>
        /// 引数 checkBoundaryFlag が true の場合、
        /// 正常に動作することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void ConstructorBoolTest02()
        {
            // 準備
            PropertyInfo senderProperty = typeof(MultipartUploadCommunicator<>).GetProperty("Sender", BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            PropertyInfo receiverProperty = typeof(MultipartUploadCommunicator<>).GetProperty("Receiver", BindingFlags.NonPublic | BindingFlags.Public | BindingFlags.Instance);
            bool expectedCheckBoundaryFlag = true;

            // 実施
            MultipartUploadCommunicator<DataSet> target = new MultipartUploadCommunicator<DataSet>(expectedCheckBoundaryFlag);

            // 確認
            MultipartSender actualSender = senderProperty.GetValue(target, null) as MultipartSender;
            DataSetXmlReceiver<DataSet> actualReceiver = receiverProperty.GetValue(target, null) as DataSetXmlReceiver<DataSet>;
            Assert.IsInstanceOfType(actualSender, typeof(MultipartSender));
            Assert.IsTrue(actualSender.CheckBoundary);
            Assert.IsInstanceOfType(actualReceiver, typeof(DataSetXmlReceiver<DataSet>));

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(MultipartUploadCommunicator<>), LogLevel.INFO));
        }
    }
}
