﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client;

namespace TERASOLUNA.Fw.ClientUT.Communication.BinaryFileReceiverData
{
    public class BinaryFileReceiver_IProgressChangeReporterStub01 : IProgressChangeReporter
    {        
        /// <summary>
        /// ReportProgressChangedメソッドが実行された場合、trueになるフラグ
        /// </summary>
        public bool _reportProgressChanged = false;

        /// <summary>
        /// DownloadReadyの状態でReportProgressChangedメソッドが実行された場合、trueになるフラグ
        /// </summary>
        public bool _reportProgressChangedReady = false;

        /// <summary>
        /// 保存先のファイルパス。
        /// </summary>
        public string _saveFilePath = null;

        /// <summary>
        /// ダウンロードの準備ができているかどうか確認するフラグ
        /// </summary>
        public bool _downloadReady = false;

        /// <summary>
        /// サーバから返却されるファイル名
        /// </summary>
        public string _contentFileName = null;

        /// <summary>
        /// このフラグがtrueの場合、ItemsのDownloadFilePathキー自体を設定しない
        /// </summary>
        public bool _notSetSaveFilePathToItems = false;

        /// <summary>
        /// 進行状況イベントから実行されるメソッド。
        /// </summary>
        /// <remarks>正常なファイルパスを返却する</remarks>
        /// <param name="e"></param>
        public virtual void ReportProgressChanged(ExecuteProgressChangedEventArgs e)
        {
            if (e.Items.Contains("DownloadReady"))
            {
                _downloadReady = Boolean.Parse(e.Items["DownloadReady"].ToString());
                _contentFileName = e.Items["ContentFileName"] as string;
                _reportProgressChangedReady = true;
            }
            else
            {
                this._reportProgressChanged = true;
            }

            if (!_notSetSaveFilePathToItems)
            {
                e.Items["DownloadFilePath"] = _saveFilePath;
            }
        }
    }
}
