﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client.Communication;
using System.Net;
using TERASOLUNA.Fw.Client;

namespace TERASOLUNA.Fw.ClientUT.Communication.BinaryFileDownloadCommunicatorData
{
    public class BinaryFileDownloadCommunicator_IHttpReceiverStub01 : IHttpReceiver
    {
        /// <summary>
        /// Receive メソッドが実行された場合、引数 request を保持するフィールド。
        /// </summary>
        public HttpWebRequest _request = null;

        /// <summary>
        /// Receive メソッドの戻り値 CommunicationResult インスタンスを保持するフィールド。
        /// </summary>
        public CommunicationResult _communicationResult = null;

        /// <summary>
        /// 引数をフィールドに保持し、フィールドに保持している戻り値を返却します。
        /// </summary>
        /// <param name="request"></param>
        /// <param name="reporter"></param>
        /// <returns></returns>
        public CommunicationResult Receive(HttpWebRequest request, IProgressChangeReporter reporter)
        {
            _request = request;
            return _communicationResult;
        }
    }
}
