﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.


namespace TERASOLUNA.Fw.Client.Forms
{
    /// <summary>
    /// 画面のモーダリティを指定する列挙体です。
    /// </summary>
    /// <remarks>
    /// <para>以下の意味を持ちます。</para>
    /// <list type="bullet">
    /// <item>
    /// <description>ApplicationModal :アプリケーション全体でモーダル。</description>
    /// </item>
    /// <item>
    /// <description>FormModal :直接開いたウィンドウのみに対してモーダル。</description>
    /// </item>
    /// <item>
    /// <description>Modeless :モードレス</description>
    /// </item>
    /// </list>
    /// </remarks>
    public enum Modality
    {
        /// <summary>
        /// 画面の表示モードとしてモーダレスを指定します。
        /// 他の画面と直接的な関係を持ちません。
        /// </summary>
        Modeless,
        /// <summary>
        /// 画面の表示モードとしてフォームモーダルを指定します。
        /// 直接の親となる画面に対してモーダルです。
        /// </summary>
        FormModal,
        /// <summary>
        /// 画面の表示モードとしてアプリケーションモーダルを指定します。
        /// アプリケーション全体に対してモーダルです。
        /// </summary>
        ApplicationModal,
    }
}
