// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Configuration;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;

namespace TERASOLUNA.Fw.Client.Configuration.View
{
    /// <summary>
    /// AvP[V\t@C viewConfiguration ZNV\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ConfigurationSection"/> NXgAViewConfiguration JX^\
    /// nhłB
    /// ڍׂɂẮA<see cref="ConfigurationSection"/> QƂĂB
    /// </remarks>
    public class ViewConfigurationSection : ConfigurationSection
    {
        /// <summary>
        /// ViewConfiguraiton ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "viewConfiguration" łB
        /// </remarks>
        private const string SECTION_NAME = "viewConfiguration";

        /// <summary>
        /// <see cref="FilesCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "files" łB
        /// </remarks>
        private const string FILES_ELEMENT_NAME = "files";

        /// <summary>
        /// <see cref="ViewCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "viewConfiguration" łB
        /// </remarks>
        private const string VIEW_CONFIGURATION_ELEMENT_NAME = "viewConfiguration";

        /// <summary>
        /// view vf id łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "id" łB
        /// </remarks>
        private const string ID_ATTRIBUTE_NAME = "id";

        /// <summary>
        ///  view vf type łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "type" łB
        /// </remarks>
        private const string TYPE_ATTRIBUTE_NAME = "type";

        /// <summary>
        /// ʑJڐݒt@CXMLOԂłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "http://www.terasoluna.jp/schema/ViewSchema.xsd" łB
        /// </remarks>
        private const string XML_NAMESPACE = "http://www.terasoluna.jp/schema/ViewSchema.xsd";

        /// <summary>
        /// ʑJڐݒt@CXMLOԃvtBbNXłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "vw" łB
        /// </remarks>
        private const string XML_NAMESPACE_PREFIX = "vw";

        /// <summary>
        /// ʑJڐݒt@C}[WŊƂvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l <see cref="XML_NAMESPACE_PREFIX"/> + ":viewConfiguration" łB
        /// </remarks>
        private const string SECTION_XPATH = XML_NAMESPACE_PREFIX + ":viewConfiguration";

        /// <summary>
        /// ʑJڐݒt@C}[WŃ}[Wvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l <see cref="SECTION_XPATH"/> + "/" + <see cref="XML_NAMESPACE_PREFIX"/> + ":view" łB
        /// </remarks>
        private const string ELEMENT_XPATH = SECTION_XPATH + "/" + XML_NAMESPACE_PREFIX + ":view";

        /// <summary>
        /// XML XL[}t@C̊SłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA.Fw.Client.Configuration.View.ViewSchema.xsd" łB
        /// </remarks>
        private const string XML_SCHEMA_FILE_NAME = "TERASOLUNA.Fw.Client.Configuration.View.ViewSchema.xsd";

        /// <summary>
        /// <see cref="ViewConfigurationSection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public ViewConfigurationSection()
        {
        }

        /// <summary>
        /// files vf擾܂B
        /// </summary>
        /// <remarks>
        /// viewConfiguration ZNV
        /// <see cref="FilesCollection"/> 擾܂B
        /// </remarks>
        [ConfigurationProperty(FILES_ELEMENT_NAME, IsDefaultCollection = false, IsRequired = true)]
        public FilesCollection Files
        {
            get
            {
                FilesCollection filesCollection = (FilesCollection)base[FILES_ELEMENT_NAME];
                return filesCollection;
            }
        }

        /// <summary>
        /// ViewConfiguration vf擾܂B
        /// </summary>
        /// <remarks>
        /// viewConfiguration ZNV
        /// <see cref="ViewCollection"/> 擾܂B
        /// </remarks>
        [ConfigurationProperty(VIEW_CONFIGURATION_ELEMENT_NAME, IsDefaultCollection = false)]
        public ViewCollection ViewCollection
        {
            get
            {
                ViewCollection viewCollection = (ViewCollection)base[VIEW_CONFIGURATION_ELEMENT_NAME];
                return viewCollection;
            }
        }

        /// <summary>
        /// files vf̐ݒe view vf𐶐 viewConfiguration vfɒǉ܂B
        /// </summary>
        /// <remarks>
        /// <para><see cref="MergeConfiguration"/> NX̃CX^X𐶐AʑJڐݒt@C
        /// ݒ}[W܂B</para>
        /// <para>}[WʑJڐݒt@C̓e <see cref="ViewElement"/> NX̃CX^X
        /// 𐶐A<see cref="ViewCollection"/> ɒǉ܂B</para>
        /// </remarks>
        public void CreateViewElements()
        {
            // ʑJڐݒt@C̐ݒ}[W
            MergeConfiguration mgConfig = 
                new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            mgConfig.LoadConfig(SECTION_NAME, Files);
            XmlDocument xmlDoc = mgConfig.MergeXmlDocument(SECTION_XPATH, ELEMENT_XPATH);

            // ʑJڐݒt@C̐ݒviewConfigurationvfɒǉ
            AddviewElements(xmlDoc);
        }

        /// <summary>
        /// ʑJڐݒt@C̓e view vf𐶐AviewConfiguration vfɒǉ܂B
        /// </summary>
        /// <param name="xmlDoc">ʑJڐݒt@C̓eێ<see cref="XmlDocument" /> B
        /// </param>
        private void AddviewElements(XmlDocument xmlDoc)
        {
            XmlNodeList list = xmlDoc.DocumentElement.ChildNodes;

            foreach (XmlNode node in list)
            {
                if (node is XmlElement)
                {
                    string name = node.Attributes[ID_ATTRIBUTE_NAME].InnerText;
                    string type = node.Attributes[TYPE_ATTRIBUTE_NAME].InnerText;
                    ViewElement element = new ViewElement(type, name);
                    ViewCollection.Add(element);
                }
            }
        }
    }
}
