// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Text;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// t@Cf[^̃oCiM@\񋟂NXłB
    /// </summary>
    public class BinaryFileSender : SenderBase<string>
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(BinaryFileSender));

        /// <summary>
        /// ReLXg̎ނHTTPwb_֊i[ۂɃL[Ƃėp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "application/octet-stream" łB</para></remarks>
        protected static readonly string CONTENT_TYPE_BINARY = "application/octet-stream";

        /// <summary>
        /// t@C̃GR[h^fR[h̃^Cv\łB
        /// </summary>
        /// <remarks>
        /// <para>̒萔̒l "B" łB"B" ́AB GR[h\܂B</para>
        /// <para>
        /// B GR[hƂ́A7bit US-ASCII ȊÕeLXggp邽߂ 7bit GR[fBOJjY
        /// ̈łBRFC 2047 Œ`Ă܂BGR[fBOASY Base64 ƓłB
        /// </para>
        /// </remarks>
        protected static readonly string ENCODE_TYPE = "B";

        /// <summary>
        /// Content-Disposition wb_Ńt@Cݒ肷ۂɗp镶łB
        /// </summary>
        /// <remarks><para>̒萔̒l "attachment; filename=?{0}?{1}?{2}?=" łB</para></remarks>
        protected static readonly string CONTENT_DISPOSITION_VALUE = "attachment; filename=?{0}?{1}?{2}?=";

        /// <summary>
        /// t@CGR[h^fR[hۂɗp镶R[h\łB
        /// </summary>
        /// <remarks>
        /// <para>̒萔̒l "ISO-2022-JP" łB</para>
        /// </remarks>
        protected static readonly string ENCODE_CHAR = "ISO-2022-JP";

        /// <summary>
        /// t@CGR[h^fR[hۂɗp<see cref="Encoding"/>łB
        /// </summary>
        /// <remarks>
        /// ftHg̃GR[fBO "ISO-2022-JP" łB
        /// </remarks>
        private Encoding _fileNameEncoding = Encoding.GetEncoding(ENCODE_CHAR);

        /// <summary>
        /// Mɗp Content-Type wb_̒l擾܂B
        /// ̃vpeB͕K "application/octet-stream" Ԃ܂B
        /// </summary>
        public override string ContentType
        {
            get
            {
                return CONTENT_TYPE_BINARY;
            }
        }

        /// <summary>
        /// t@CGR[h^fR[hۂɗp<see cref="Encoding"/>擾܂͐ݒ肵܂B
        /// </summary>
        /// <remarks>
        /// ̃vpeB <c>null</c> QƂݒ肵ꍇAftHg̃GR[fBOp܂B
        /// ftHg̃GR[fBO "ISO-2022-JP" łB
        /// </remarks>
        public Encoding FileNameEncoding
        {
            get
            {
                return _fileNameEncoding;
            }
            set
            {
                if (value == null)
                {
                    _fileNameEncoding = Encoding.GetEncoding(ENCODE_CHAR);
                }
                else
                {
                    _fileNameEncoding = value;
                }
            }
        }

        /// <summary>
        /// <see cref="BinaryFileSender"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public BinaryFileSender()
        {
        }

        /// <summary>
        /// <paramref name="request"/> œnꂽ <see cref="HttpWebRequest"/> pāA
        /// <paramref name="filePath"/> ŕ\t@C <paramref name="headerCollection"/> 
        /// ̏𑗐M܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// M HTTP NGXg{fB́A<paramref name="filePath"/> ŕ\t@C̃oCi\łB
        /// </para>
        /// <para>
        /// HTTP NGXgwb_ɂ <paramref name="headerCollection"/> Ɋi[ꂽL[/l̏񂪑SĒǉ܂B
        /// <paramref name="headerCollection"/> Ɋi[L[/l͂ꂼ HTTP NGXgwb_̃L[/lƂėp
        /// \Ȍ`𖞑Kv܂B͋ḰARFC 2616 "request-header" Œ`Ă܂B
        /// </para>
        /// <para>
        /// <paramref name="reporter"/>  <c>null</c> QƂł͂ȂꍇA
        /// <see cref="SenderBase{TParam}.BufferSize"/> vpeBɐݒ肳ꂽobt@TCỸf[^iftHg8 KB jT[oɑM閈ɁA
        /// <see cref="IProgressChangeReporter.ReportProgressChanged"/> Cxg𔭐܂B
        /// </para>
        /// </remarks>
        /// <param name="request">MsNGXgIuWFNgB</param>
        /// <param name="filePath">Mf[^i[IuWFNgB</param>
        /// <param name="headerCollection">MHTTPwb_Ƃėpwb_̃RNVB</param>
        /// <param name="reporter">is󋵒ʒms <see cref="IProgressChangeReporter"/> CX^XB </param> 
        /// <exception cref="ArgumentException">
        /// <paramref name="filePath"/> 󕶎łB
        /// </exception>
        /// <exception cref="System.IO.FileNotFoundException">
        /// ʐMŕKvȃt@C܂B
        /// </exception>
        /// <exception cref="WebException">
        /// ʐMG[܂B܂́ANGXgLZ܂B
        /// </exception>
        protected override void SendRequest(HttpWebRequest request,
                                            string filePath,
                                            IDictionary<string, string> headerCollection,
                                            IProgressChangeReporter reporter)
        {
            if (filePath.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "filePath");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // t@C݃`FbN
            if (!File.Exists(filePath))
            {
                string message = string.Format(Properties.Resources.E_COMMUNICATION_FILE_NOT_FOUND, filePath);
                FileNotFoundException exception = new FileNotFoundException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // NGXg̃wb_Ƀt@Cl[ǉ
            string fileName = Path.GetFileName(filePath);
            string encodedFileName = EncodeFileName(fileName);
            request.Headers.Add(CONTENT_DISPOSITION,
                string.Format(CONTENT_DISPOSITION_VALUE, _fileNameEncoding.WebName, ENCODE_TYPE, encodedFileName));

            // Abv[ht@C̓ǂݍݏ
            using (Stream upFileStream = new FileStream(filePath, FileMode.Open, FileAccess.Read))
            {
                int percentage = 0;
                long sendSize = 0L;
                long totalSize = upFileStream.Length;

                // ContentLength̐ݒ
                request.ContentLength = totalSize;

                // NGXg֏ݏ
                using (Stream reqStream = request.GetRequestStream())
                {
                    // M̃Oo
                    if (_log.IsTraceEnabled)
                    {
                        // URL
                        _log.Trace(string.Format(Properties.Resources.T_REQUEST_SEND_ADDRESS, request.Address));

                        // HTTPwb_
                        StringBuilder requestHeaders = new StringBuilder();
                        requestHeaders.AppendLine(Properties.Resources.T_REQUEST_SEND_HEADER);
                        foreach (string key in request.Headers.AllKeys)
                        {
                            requestHeaders.AppendLine(string.Format(
                            Properties.Resources.T_DICTIONARY_KEY_VALUE, key, request.Headers[key]));
                        }
                        _log.Trace(requestHeaders.ToString().Trim());

                        // Mt@C
                        _log.Trace(string.Format(Properties.Resources.T_UPLOAD_FILE_PATH, filePath));
                    }

                    int localBufferSize = BufferSize;
                    byte[] buffer = new byte[localBufferSize];
                    int readSize = upFileStream.Read(buffer, 0, localBufferSize);
                    while (readSize > 0)
                    {
                        // NGXgփoCif[^
                        reqStream.Write(buffer, 0, readSize);

                        // Cxgʒm
                        sendSize += readSize;
                        if (reporter != null)
                        {
                            if (totalSize > 0)
                            {
                                percentage = CalcSendPercentage(sendSize, totalSize);
                            }
                            reporter.ReportProgressChanged(new ExecuteProgressChangedEventArgs(percentage));
                        }

                        readSize = upFileStream.Read(buffer, 0, localBufferSize);
                    }
                }
            }
        }

        /// <summary>
        /// <paramref name="fileName"/> Base64 GR[hʂԂ܂B
        /// </summary>
        /// <param name="fileName">GR[ht@CB</param>
        /// <returns>Base64 GR[hꂽB</returns>
        protected virtual string EncodeFileName(string fileName)
        {
            byte[] byteData = _fileNameEncoding.GetBytes(fileName);
            return Convert.ToBase64String(byteData);
        }
    }
}
