// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Data;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.BLogic
{
    /// <summary>
    /// t@C̑MAXMLf[^̎MsrWlXWbNNXłB
    /// </summary>
    /// <remarks>
    /// <see cref="BinaryFileUploadCommunicator{TResult}"/> gpăT[oƒʐMs܂B
    /// </remarks>
    /// <typeparam name="TResult">
    /// MXMLf[^ <paramref name="TResult"/> ^̌^tf[^Zbgɓǂݍ݂܂B
    /// </typeparam>
    public class BinaryFileUploadBLogic<TResult> : CommunicateBLogicBase<string>
        where TResult : DataSet, new()
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(BinaryFileUploadBLogic<TResult>));

        /// <summary>
        /// Abv[ht@CpX <see cref="DataSet"/> 擾ۂɃL[Ƃėpe[ułB
        /// </summary>
        /// <remarks>̒萔̒l "File" łB</remarks>
        protected static readonly string BINARY_FILE_TABLE_NAME = "File";

        /// <summary>
        /// Abv[ht@CpX <see cref="DataSet"/> 擾ۂɃL[ƂėpJłB
        /// </summary>
        /// <remarks>̒萔̒l "FilePath" łB</remarks>
        protected static readonly string BINARY_FILE_COLUMN_NAME = "FilePath";

        /// <summary>
        /// <see cref="BinaryFileUploadBLogic{TResult}"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public BinaryFileUploadBLogic()
        {
        }

        /// <summary>
        /// t@C̑MAXMLf[^̎Ms <see cref="ICommunicator{DataSet}"/> 𐶐܂B
        /// </summary>
        /// <remarks>
        /// ł <see cref="BinaryFileUploadCommunicator{TResult}"/> 𐶐܂B
        /// </remarks>
        /// <returns>
        /// t@C̑MAXMLf[^̎Ms <see cref="ICommunicator{DataSet}"/>B
        /// </returns>
        protected override ICommunicator<string> CreateCommunicator()
        {
            return new BinaryFileUploadCommunicator<TResult>();
        }

        /// <summary>
        /// t@CMAXMLf[^̎Ms܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̓f[^ <paramref name="communicateBLogicParam"/> Ɋi[ꂽf[^Zbg <see cref="BINARY_FILE_TABLE_NAME"/> 
        /// e[u <see cref="BINARY_FILE_COLUMN_NAME"/> J 1 sڂAbv[ht@C̃pX擾܂B
        /// <see cref="ICommunicator{String}"/>  <see cref="ICommunicator{String}.Communicate"/> Ƀt@CpX
        /// năAbv[hs܂B
        /// Mf[^ <paramref name="TResult"/> ^̌^tf[^Zbgɓǂݍ݂܂B
        /// </para>
        /// <para>
        /// ʐMNXƂāAł <see cref="BinaryFileUploadCommunicator{TResult}"/> 𗘗p܂B
        /// </para>
        /// </remarks>
        /// <param name="communicateBLogicParam">
        /// Mt@C̃pXݒ肵 <see cref="BLogicParam"/>B
        /// </param>
        /// <param name="requestHeaders">
        /// NGXg̃wb_\閼Oƒl̃yAi[Ă <see cref="IDictionary{String, String}"/>B
        /// </param>
        /// <returns>
        /// ʐMʂi[ <see cref="CommunicationResult"/>B
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="paramData"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="communicateBLogicParam"/>  <see cref="BINARY_FILE_TABLE_NAME"/> e[u܂B
        /// </item>
        /// <item>
        /// <paramref name="communicateBLogicParam"/>  <see cref="BINARY_FILE_TABLE_NAME"/> e[u <see cref="BINARY_FILE_COLUMN_NAME"/> J܂B
        /// </item>
        /// <item>
        /// <paramref name="communicateBLogicParam"/>  <see cref="BINARY_FILE_TABLE_NAME"/> e[uɃR[h܂B
        /// </item>
        /// <item>
        /// ʐMŕKvȃf[^słB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ServerException">
        /// T[oAvP[Vőz肵ȂO܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// f[^̑MɃG[܂B
        /// </exception>
        protected override CommunicationResult Communicate(BLogicParam communicateBLogicParam, 
                                                           IDictionary<string, string> requestHeaders)
        {
            DataTable fileTable = communicateBLogicParam.ParamData.Tables[BINARY_FILE_TABLE_NAME];

            if (fileTable == null)
            {
                throw new ArgumentException(string.Format(
                    Properties.Resources.E_BLOGIC_TABLE_NOT_FOUND, 
                    communicateBLogicParam.ParamData.GetType().FullName));
            }

            if (fileTable.Rows.Count == 0)
            {
                throw new ArgumentException(string.Format(
                    Properties.Resources.E_BLOGIC_RECORD_NOT_FOUND, 
                    communicateBLogicParam.ParamData.GetType().FullName));
            }

            if (!fileTable.Columns.Contains(BINARY_FILE_COLUMN_NAME))
            {
                throw new ArgumentException(string.Format(
                    Properties.Resources.E_BLOGIC_COLUMN_NOT_FOUND, 
                    communicateBLogicParam.ParamData.GetType().FullName));
            }

            // Abv[ht@CpX̎擾
            string filePath = fileTable.Rows[0][BINARY_FILE_COLUMN_NAME] as string;
            if (string.IsNullOrEmpty(filePath))
            {
                string message = string.Format(Properties.Resources.E_BLOGIC_INVALID_DTOTABLE,
                                               BINARY_FILE_TABLE_NAME, BINARY_FILE_COLUMN_NAME);
                throw new ArgumentException(message);
            }

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_BEGIN_COMMUNICATOR_FUNCTION, 
                    Communicator.GetType().FullName));
            }

            CommunicationResult result = Communicator.Communicate(filePath, requestHeaders);

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(
                    Properties.Resources.D_END_COMMUNICATOR_FUNCTION, 
                    Communicator.GetType().FullName));
            }

            return result;
        }
    }
}
