/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.init;

import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * WuǗe[u擾Wu˗p<code>Abstract</code>B
 * WuǗe[u擾Wu˗i[pNX͂
 * <code>Abstract</code>NXKvB
 *
 */
public abstract class AbstractJobControlInfo implements JobInfo, WorkUnit {

    /**
     * Wuf[IpWuID̕B
     */
    public static final String STOP_DAEMON = "STOP"; 
    
    /**
     * Wup[^̋؂蕶B
     */
    private String jobParametersSplitStr = null;

    /**
     * WuIR[hݒB
     *
     * @param jobExitCode WuIR[h
     */
    public abstract void setJobExitCode(String jobExitCode);
    
    /**
     * WuN󋵂ݒB
     *
     * @param jobState WuN
     */
    public abstract void setJobState(String jobState);
    
    /**
     * L[̏I[ł邩]B
     *
     * @return <code>false</code>Ԃ
     */
    public final boolean isEndMark() {
        return false;
    }
    
    /**
     * Wup[^̋؂蕶B
     * 
     * @param jobParametersSplitStr Wup[^̋؂蕶
     */
    public void setJobParametersSplitStr(String jobParametersSplitStr) {
        this.jobParametersSplitStr = jobParametersSplitStr;
    }

    /**
     * WuReLXg擾B
     *
     * <p>̃NX̎ł́A <code>UnsupportedOperationException</code>
     * X[B</p>
     * 
     * @return  <code>UnsupportedOperationException</code> X[邽
     * A^[Ȃ
     */
    public final JobContext getJobContext() {
        throw new UnsupportedOperationException();
    }

    /**
     * WuReLXgݒ肷B
     * 
     * <p>̃NX̎ł́A <code>UnsupportedOperationException</code>
     * X[B</p>
     *
     * @param jobContext WuReNXg
     */
    public final void setJobContext(JobContext jobContext) {
        throw new UnsupportedOperationException();
    }

    /**
     * Wup[^̋؂蕶擾B
     * 
     * @return Wup[^̋؂蕶
     */
    protected String getJobParametersSplitStr() {
        return jobParametersSplitStr;
    }

}
