/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import jp.terasoluna.fw.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateUtil {
    private static Log log = LogFactory.getLog(DateUtil.class);
    private static final String GENGO_KEY = "wareki.gengo.";
    private static final Map<Date, String> GENGO_NAME = new HashMap<Date, String>();
    private static final Map<Date, String> GENGO_ROMAN = new HashMap<Date, String>();
    private static final Date[] GENGO_BEGIN_DATES;
    private static final int[] GENGO_BEGIN_YEARS;

    public static Date getSystemTime() {
        Calendar calendar = Calendar.getInstance();
        return calendar.getTime();
    }

    public static String dateToWarekiString(String format, Date date) {
        StringBuilder sb = new StringBuilder();
        boolean inQuote = false;
        char prevCh = '\u0000';
        int count = 0;
        for (int i = 0; i < format.length(); ++i) {
            char ch = format.charAt(i);
            if (ch != prevCh && count > 0) {
                if (prevCh == 'G' && count >= 4) {
                    sb.append(DateUtil.getWarekiGengoName(date));
                } else if (prevCh == 'G') {
                    sb.append('\'');
                    sb.append(DateUtil.getWarekiGengoRoman(date));
                    sb.append('\'');
                } else if (prevCh == 'y') {
                    sb.append(DateUtil.getWarekiYear(date));
                }
                count = 0;
            }
            if (ch == '\'') {
                if (i + 1 < format.length() && format.charAt(i + 1) == '\'') {
                    sb.append('\'');
                    ++i;
                    continue;
                }
                sb.append('\'');
                inQuote = !inQuote;
                continue;
            }
            if (!(inQuote || ch != 'G' && ch != 'y')) {
                prevCh = ch;
                ++count;
                continue;
            }
            sb.append(ch);
        }
        if (count > 0) {
            if (prevCh == 'G' && count >= 4) {
                sb.append(DateUtil.getWarekiGengoName(date));
            } else if (prevCh == 'G') {
                sb.append('\'');
                sb.append(DateUtil.getWarekiGengoRoman(date));
                sb.append('\'');
            } else if (prevCh == 'y') {
                sb.append(DateUtil.getWarekiYear(date));
            }
        }
        SimpleDateFormat sdf = new SimpleDateFormat(sb.toString(), Locale.JAPAN);
        sdf.getCalendar().setLenient(false);
        sdf.setLenient(false);
        return sdf.format(date);
    }

    public static String getWarekiGengoName(Date date) {
        for (int i = GENGO_BEGIN_DATES.length - 1; i >= 0; --i) {
            if (date.before(GENGO_BEGIN_DATES[i])) continue;
            return GENGO_NAME.get(GENGO_BEGIN_DATES[i]);
        }
        throw new IllegalArgumentException("Wareki Gengo Name not found for " + date);
    }

    public static String getWarekiGengoRoman(Date date) {
        for (int i = GENGO_BEGIN_DATES.length - 1; i >= 0; --i) {
            if (date.before(GENGO_BEGIN_DATES[i])) continue;
            return GENGO_ROMAN.get(GENGO_BEGIN_DATES[i]);
        }
        throw new IllegalArgumentException("Wareki Gengo Roman not found for " + date);
    }

    public static int getWarekiYear(Date date) {
        for (int i = GENGO_BEGIN_DATES.length - 1; i >= 0; --i) {
            if (date.before(GENGO_BEGIN_DATES[i])) continue;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            return year - GENGO_BEGIN_YEARS[i] + 1;
        }
        throw new IllegalArgumentException("Wareki Gengo not found for " + date);
    }

    static {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        Enumeration<String> enumaration = PropertyUtil.getPropertyNames(GENGO_KEY);
        HashSet<String> ids = new HashSet<String>();
        while (enumaration.hasMoreElements()) {
            String key = enumaration.nextElement();
            String id = key.substring(GENGO_KEY.length(), key.lastIndexOf("."));
            if (ids.contains(id)) continue;
            String name = PropertyUtil.getProperty(GENGO_KEY + id + ".name", "");
            String roman = PropertyUtil.getProperty(GENGO_KEY + id + ".roman", "");
            String start = PropertyUtil.getProperty(GENGO_KEY + id + ".startDate");
            if (start == null) {
                log.error((Object)(GENGO_KEY + id + ".startDate not found"));
                continue;
            }
            try {
                Date date = sdf.parse(start);
                GENGO_NAME.put(date, name);
                GENGO_ROMAN.put(date, roman);
                log.info((Object)("registerd: " + date + ", " + name + ", " + roman));
            }
            catch (ParseException e) {
                log.error((Object)e.getMessage());
            }
            ids.add(id);
        }
        Set<Date> keySet = GENGO_NAME.keySet();
        int size = keySet.size();
        GENGO_BEGIN_DATES = keySet.toArray(new Date[size]);
        Arrays.sort(GENGO_BEGIN_DATES);
        GENGO_BEGIN_YEARS = new int[size];
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < GENGO_BEGIN_DATES.length; ++i) {
            calendar.setTime(GENGO_BEGIN_DATES[i]);
            DateUtil.GENGO_BEGIN_YEARS[i] = calendar.get(1);
        }
    }
}

