/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.controlbreak;

import java.util.ArrayList;
import java.util.List;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakChunk;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakDef;
import jp.terasoluna.fw.batch.controlbreak.ControlBreakRowObject;
import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.openapi.JobContext;
import org.apache.commons.collections.FastHashMap;

public class ControlBreakChunker
implements CollectedDataHandler {
    private WorkQueue queue;
    private final ControlBreakDef controlBreakDef;
    private ControlBreakChunk currentChunk;
    private JobContext jobContext;
    private int chunkSize = 20;
    private boolean chunkControlFlg = false;
    private ControlBreakRowObject newRow = null;

    public ControlBreakChunker(WorkQueue queue, JobContext jobContext, ControlBreakDef controlBreakDef, int chunkSize) {
        this.queue = queue;
        this.jobContext = jobContext;
        this.controlBreakDef = controlBreakDef;
        this.chunkSize = chunkSize;
        if (controlBreakDef.getChunkControlBreakDefItem() == null || controlBreakDef.getChunkControlBreakDefItem().getBreakKey().size() == 0) {
            this.chunkControlFlg = true;
        }
        this.currentChunk = new ControlBreakChunk(jobContext, controlBreakDef, chunkSize);
    }

    public void handle(Object row, int collected) {
        this.newRow = this.currentChunk.setNext(row);
        if (this.currentChunk.isChunkControlBreak() || this.chunkControlFlg && this.currentChunk.size() >= this.chunkSize) {
            ControlBreakRowObject chunkRow = new ControlBreakRowObject(ControlBreakChunk.CHUNK_BREAK_MARK, this.newRow.getControlBreakKeyList(), this.newRow.getControlBreakMap());
            this.currentChunk.add(chunkRow);
            this.queue.put(this.currentChunk);
            FastHashMap methodMap = this.currentChunk.getMethodMap();
            this.currentChunk = new ControlBreakChunk(this.jobContext, this.controlBreakDef, this.chunkSize, this.currentChunk.getNextData(), this.currentChunk.getChunkNextData());
            this.currentChunk.setMethodMap(methodMap);
            this.newRow = new ControlBreakRowObject(this.newRow.getRowObject(), new ArrayList<List<String>>(), null);
        }
        this.currentChunk.add(this.newRow);
    }

    public void close() {
        ControlBreakRowObject row = null;
        row = this.newRow != null ? this.currentChunk.setLastData(this.newRow.getRowObject()) : new ControlBreakRowObject(ControlBreakChunk.END_MARK, null, null);
        this.currentChunk.add(row);
        this.currentChunk.setEndChunk(true);
        this.queue.put(this.currentChunk);
        this.currentChunk = null;
        this.queue.close();
    }
}

