/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.util.Map;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.dao.FileException;

/**
 * CSVt@Cp̃t@CANZX(f[^)NXB
 * 
 * <p>
 * t@CsIuWFNgf[^ǂݍ݁A1s̃f[^CSV`Ńt@C
 * ɏށB
 * </p>
 * 
 * <b>pt@CsIuWFNg̃Ame[V</b><br>
 * @D@{@link FileFormat}̐ݒ荀<br>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b>_ږ</b> </td>
 *    <td> <b>ږ</b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>s؂蕶</code> </td>
 *    <td> <code>lineFeedChar</code> </td>
 *    <td> <code>VXe̍s؂蕶</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>͂ݕ</code> </td>
 *    <td> <code>encloseChar</code> </td>
 *    <td> <code>Ȃ('\u0000')</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>t@CGR[fBO</code> </td>
 *    <td> <code>fileEncodeing</code> </td>
 *    <td> <code>VXẽt@CGR[fBO</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>t@C㏑tO</code> </td>
 *    <td> <code>overWriteFlg</code> </td>
 *    <td> <code>false</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *  </table>
 * </div>
 * <br>
 * AD@{@link jp.terasoluna.fw.file.annotation.InputFileColumn}A@{@link jp.terasoluna.fw.file.annotation.OutputFileColumn}̐ݒ荀<br>
 * <div align="center">
 *  <table width="90%" border="1" bgcolor="#FFFFFF">
 *   <tr>
 *    <td> <b>_ږ</b> </td>
 *    <td> <b>ږ</b> </td>
 *    <td> <b>ftHgl</b> </td>
 *    <td> <b>K{</b> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>JCfbNX</code> </td>
 *    <td> <code>columnIndex</code> </td>
 *    <td> - </td>
 *    <td> <code>K{</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>tH[}bg</code> </td>
 *    <td> <code>columnFormat</code> </td>
 *    <td> <code>""</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>oCg</code> </td>
 *    <td> <code>bytes</code> </td>
 *    <td> - </td>
 *    <td> <code>K{</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>pfBO</code> </td>
 *    <td> <code>paddingType</code> </td>
 *    <td> <code>pfBOȂ</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>pfBO</code> </td>
 *    <td> <code>paddingChar</code> </td>
 *    <td> <code>' '</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>g</code> </td>
 *    <td> <code>trimType</code> </td>
 *    <td> <code>gȂ</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>g</code> </td>
 *    <td> <code>trimChar</code> </td>
 *    <td> <code>' '</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *   <tr>
 *    <td> <code>ϊ</code> </td>
 *    <td> <code>stringConverter</code> </td>
 *    <td> <code>NullStringConverter.class</code> </td>
 *    <td> <code>IvV</code> </td>
 *   </tr>
 *  </table>
 * </div>
 * <br>
 * <b>ӎ</b><br>
 * <ul>
 * @<li>؂蕶<code>','</cod>ȊOɐݒ肷邱Ƃ͏oȂB(G[)</li>
 * </ul>
 * 
 * @param <T> t@CsIuWFNg
 */
public class CSVFileLineWriter<T> extends AbstractFileLineWriter<T> {

    /**
     * ؂蕶B CSVt@Co͂̏ꍇA؂蕶́u,(J})vŌŒB
     */
    private static final char DELIMITER = ',';

    /**
     * ͂ݕB
     */
    private char encloseChar = Character.MIN_VALUE;

    /**
     * RXgN^B
     * 
     * @param fileName t@C
     * @param clazz p[^NX
     * @param columnFormatterMap eLXg擾[
     */
    public CSVFileLineWriter(String fileName, Class<T> clazz,
            Map<String, ColumnFormatter> columnFormatterMap) {
        
        super(fileName, clazz, columnFormatterMap);
        
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        
        //؂蕶lȊȌꍇAOX[B
        if (fileFormat.delimiter() != DELIMITER) {
            throw new FileException("Delimiter can not change.",
                    new IllegalStateException(), fileName);
        }
        
        //͂ݕݒ肷B
        encloseChar = fileFormat.encloseChar();
        
        //
        super.init();
    }

    /**
     * ؂蕶擾B<br>
     * CSVt@Co͂̏ꍇA؂蕶́u,(J})vŌŒB
     * @return ؂蕶
     */
    public char getDelimiter() {
        return DELIMITER;
    }

    /**
     * ͂ݕ擾B
     * @return ͂ݕ
     */
    public char getEncloseChar() {
        return encloseChar;
    }
}
