/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.controlbreak;

import java.util.List;
import java.util.Map;

/**
 * Rg[uCNpRowIuWFNgNXB 
 * Ώۃf[^bvAΏۃf[^ Rg[uCN
 * Ă邩ǂێB
 * 
 */
public class ControlBreakRowObject {

    /**
     * Ώۃf[^B
     */
    private Object rowObject;

    /**
     * Rg[uCNL[XgB
     */
    private List<List<String>> controlBreakKeyList;

    /**
     * Rg[uCNL[}bvB
     */
    private Map<String, Object> controlBreakMap;

    /**
     * RXgN^B
     * 
     * @param rowObject Ώۃf[^
     * @param controlBreakKeyList Rg[uCNL[Xg
     * @param controlBreakMap Rg[uCNL[}bv
     */
    public ControlBreakRowObject(Object rowObject,
            List<List<String>> controlBreakKeyList,
            Map<String, Object> controlBreakMap) {
        this.rowObject = rowObject;
        this.controlBreakKeyList = controlBreakKeyList;
        this.controlBreakMap = controlBreakMap;
    }

    /**
     * Ώۃf[^擾B
     * 
     * @return Ώۃf[^
     */
    public Object getRowObject() {
        return rowObject;
    }

    /**
     * Rg[uCNL[Xg擾B
     * 
     * @return Rg[uCNL[Xg
     */
    public List<List<String>> getControlBreakKeyList() {
        return controlBreakKeyList;
    }

    /**
     * Rg[uCNL[}bv擾B
     * 
     * @return Rg[uCNL[}bv
     */
    public Map<String, Object> getControlBreakMap() {
        return controlBreakMap;
    }
}
