/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.util.Map;
import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.AbstractFileLineWriter;
import jp.terasoluna.fw.file.dao.standard.ColumnFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableFileLineWriter<T>
extends AbstractFileLineWriter<T> {
    private char delimiter = (char)44;
    private char encloseChar = '\u0000';

    public VariableFileLineWriter(String fileName, Class<T> clazz, Map<String, ColumnFormatter> columnFormatterMap) {
        super(fileName, clazz, columnFormatterMap);
        FileFormat fileFormat = clazz.getAnnotation(FileFormat.class);
        if (fileFormat.delimiter() == '\u0000') {
            throw new FileException("Delimiter can not use '\\u0000'.", new IllegalStateException(), fileName);
        }
        this.delimiter = fileFormat.delimiter();
        this.encloseChar = fileFormat.encloseChar();
        super.init();
    }

    @Override
    public char getDelimiter() {
        return this.delimiter;
    }

    @Override
    public char getEncloseChar() {
        return this.encloseChar;
    }
}

