/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.core;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import jp.terasoluna.fw.batch.core.BLogicExecutor;
import jp.terasoluna.fw.batch.core.BatchUpdateException;
import jp.terasoluna.fw.batch.core.BatchUpdateProcessor;
import jp.terasoluna.fw.batch.core.BatchUpdateResultHandler;
import jp.terasoluna.fw.batch.core.Chunk;
import jp.terasoluna.fw.batch.core.ExceptionHandlerUtil;
import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobExceptionHandler;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.openapi.JobContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobWorker
implements Workable<Chunk> {
    private static Log log = LogFactory.getLog(JobWorker.class);
    protected LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap = null;
    protected JobExceptionHandler defaultJobExceptionHandler = null;
    protected BatchUpdateProcessor batchUpdateProcessor = null;
    protected BatchUpdateResultHandler batchUpdateResultHandler = null;
    private BLogicExecutor blogicExecutor = null;

    @Override
    public void work(Chunk chunk, JobStatus jobStatus) {
        this.writeStartLog(jobStatus);
        if (chunk.size() == 0) {
            throw new IllegalArgumentException("chunk size is 0");
        }
        ArrayList<LinkedHashMap<String, Object>> batchUpdateMapList = new ArrayList<LinkedHashMap<String, Object>>();
        for (Object blogicInputData : chunk) {
            if (jobStatus.isShutdownImmediate()) {
                jobStatus.suspend();
                return;
            }
            this.blogicExecutor.executeBLogic(blogicInputData, chunk.getJobContext(), jobStatus, batchUpdateMapList);
            if (jobStatus.isContinue()) continue;
            return;
        }
        this.processBatchUpdate(chunk.getJobContext(), jobStatus, batchUpdateMapList);
        this.writeEndLog(jobStatus);
    }

    protected void processBatchUpdate(JobContext jobContext, JobStatus jobStatus, List<LinkedHashMap<String, Object>> batchUpdateMapList) {
        if (batchUpdateMapList.size() == 0) {
            return;
        }
        try {
            this.batchUpdateProcessor.processBatchUpdate(batchUpdateMapList);
            this.batchUpdateResultHandler.handle(jobStatus, batchUpdateMapList);
        }
        catch (RuntimeException e) {
            BatchUpdateException wrappingException = new BatchUpdateException(e, batchUpdateMapList);
            JobExceptionHandler handler = ExceptionHandlerUtil.getJobExceptionHandler(wrappingException, this.exceptionHandlerMap, this.defaultJobExceptionHandler);
            handler.handlException(jobContext, wrappingException, jobStatus);
        }
    }

    public void setExceptionHandlerMap(LinkedHashMap<JobException, JobExceptionHandler> exceptionHandlerMap) {
        this.exceptionHandlerMap = exceptionHandlerMap;
    }

    public void setBatchUpdateProcessor(BatchUpdateProcessor batchUpdateProcessor) {
        this.batchUpdateProcessor = batchUpdateProcessor;
    }

    public void setBlogicExecutor(BLogicExecutor blogicExecutor) {
        this.blogicExecutor = blogicExecutor;
    }

    public void setBatchUpdateResultHandler(BatchUpdateResultHandler batchUpdateResultHandler) {
        this.batchUpdateResultHandler = batchUpdateResultHandler;
    }

    public void setDefaultJobExceptionHandler(JobExceptionHandler defaultJobExceptionHandler) {
        this.defaultJobExceptionHandler = defaultJobExceptionHandler;
    }

    private void writeStartLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("\u3010START\u3011");
            logStr.append(" [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("]");
            logStr.append(" [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("]");
            logStr.append(" [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("]");
            logStr.append(" [BLogicExecutorName=");
            logStr.append(this.blogicExecutor.getClass().getSimpleName());
            logStr.append("]");
            logStr.append(" [BatchUpdateProcessorName=");
            logStr.append(this.batchUpdateProcessor.getClass().getSimpleName());
            logStr.append("]");
            logStr.append(" [BatchUpdateResultHandlerName=");
            logStr.append(this.batchUpdateResultHandler.getClass().getSimpleName());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    private void writeEndLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("\u3010 END \u3011");
            logStr.append(" [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("]");
            logStr.append(" [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("]");
            logStr.append(" [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("]");
            logStr.append(" [BLogicExecutorName=");
            logStr.append(this.blogicExecutor.getClass().getSimpleName());
            logStr.append("]");
            logStr.append(" [BatchUpdateProcessorName=");
            logStr.append(this.batchUpdateProcessor.getClass().getSimpleName());
            logStr.append("]");
            logStr.append(" [BatchUpdateResultHandlerName=");
            logStr.append(this.batchUpdateResultHandler.getClass().getSimpleName());
            logStr.append("]");
            logStr.append(" [BatchUpdateCount=");
            logStr.append(jobStatus.getBatchUpdateCount());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }
}

