/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.core;

import jp.terasoluna.fw.batch.core.CollectedDataHandler;
import jp.terasoluna.fw.batch.core.CollectedDataHandlerFactory;
import jp.terasoluna.fw.batch.core.Collector;
import jp.terasoluna.fw.batch.core.CollectorResult;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.QueueingException;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollector<T extends JobContext>
implements Collector<T> {
    private static Log log = LogFactory.getLog(AbstractCollector.class);
    private CollectedDataHandlerFactory collectedDataHandlerFactory = null;

    @Override
    public CollectorResult collect(T jobContext, WorkQueue workQueue, JobStatus jobStatus) {
        this.writeStartLog(jobStatus);
        CollectedDataHandler collectedDataHandler = this.collectedDataHandlerFactory.getHandler(workQueue, (JobContext)jobContext);
        CollectorResult collectorResult = null;
        try {
            collectorResult = this.doCollect(jobContext, collectedDataHandler, jobStatus);
            collectedDataHandler.close();
        }
        catch (QueueingException e) {
            if (jobStatus.isExecuting()) {
                collectedDataHandler.close();
                throw e;
            }
            collectorResult = new CollectorResult(ReturnCode.NORMAL_END, -1);
        }
        catch (RuntimeException e) {
            collectedDataHandler.close();
            throw e;
        }
        this.writeEndLog(jobStatus);
        return collectorResult;
    }

    public void setCollectedDataHandlerFactory(CollectedDataHandlerFactory collectedDataHandlerFactory) {
        this.collectedDataHandlerFactory = collectedDataHandlerFactory;
    }

    protected abstract CollectorResult doCollect(T var1, CollectedDataHandler var2, JobStatus var3);

    private void writeStartLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("\u3010START\u3011");
            logStr.append(" [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("]");
            logStr.append(" [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("]");
            logStr.append(" [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("]");
            logStr.append(" [ClassName=");
            logStr.append(this.getClass().getSimpleName());
            logStr.append("]");
            logStr.append(" [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }

    private void writeEndLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("\u3010 END \u3011");
            logStr.append(" [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("]");
            logStr.append(" [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("]");
            logStr.append(" [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("]");
            logStr.append(" [ClassName=");
            logStr.append(this.getClass().getSimpleName());
            logStr.append("]");
            logStr.append(" [JobState=");
            logStr.append((Object)jobStatus.getJobState());
            logStr.append("]");
            logStr.append(" [collected=");
            logStr.append(jobStatus.getCollected());
            logStr.append("]");
            log.debug((Object)logStr.toString());
        }
    }
}

