/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.taglib;

import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.VariableInfo;

import junit.framework.TestCase;

/**
 * DecimalTei ubN{bNXeXgB<br>
 * O<br>
 * -<br>
 */
public class DecimalTeiTest extends TestCase {

    // eXgΏۃNX
    DecimalTei tag = null;

    /**
     * Constructor for IterateRowSetTeiTest.
     * @param arg0
     */
    public DecimalTeiTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        tag = new DecimalTei();
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    /**
     * testGetVariableInfo01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FFE
     * <br><br>
     * ͒lF() data:new TagData({"id", "1"})<br>
     *         
     * <br>
     * ҒlF(߂l) VariableInfo[]:Not Null<br>
     *         (ԕω) variableInfo[0].varName:dataid<br>
     *         (ԕω) variableInfo[0].className:"java.lang.String"<br>
     *         (ԕω) variableInfo[0].declare:true<br>
     *         (ԕω) variableInfo[0].scope:VariableInfo.AT_BEGIN<br>
     *         (ԕω) variableInfo̔z:1<br>
     *         
     * <br>
     * TagDataɕێĂidNot NULLŁAVariableInfozdataid(VariableInfoRXgN^̑NotNull)Zbgԋp邱ƂmFeXgP[X
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetVariableInfo01() throws Exception {
        //eXgf[^ݒ
        Object[][] att = {{"id", "1"}};
        TagData data = new TagData(att);

        //eXgs
        VariableInfo[] vInfo = tag.getVariableInfo(data);

        //eXgʊmF
        assertEquals(1, vInfo.length);
        assertEquals("1", vInfo[0].getVarName());
        assertEquals("java.lang.String", vInfo[0].getClassName());
        assertTrue(vInfo[0].getDeclare());
        assertEquals(VariableInfo.AT_BEGIN, vInfo[0].getScope());

    }

    /**
     * testGetVariableInfo02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FFE
     * <br><br>
     * ͒lF() data:new TagData({})<br>
     *         
     * <br>
     * ҒlF(߂l) VariableInfo[]:̔z<br>
     *         (ԕω) variableInfo̔z:0<br>
     *         
     * <br>
     * TagDataɕێĂidNULLŁAVariableInfoz̃CX^Xԋp邱ƂmFeXgP[X
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetVariableInfo02() throws Exception {
        //eXgf[^ݒ
        Object[][] att = {};
        TagData data = new TagData(att);

        //eXgs
        VariableInfo[] vInfo = tag.getVariableInfo(data);

        //eXgʊmF
        assertEquals(0, vInfo.length);

    }

    /**
     * testGetVariableInfo03()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() data:Null<br>
     *         
     * <br>
     * ҒlF(ԕω) O:NullPointerException<br>
     *         
     * <br>
     * TagDataNULLŁANullPointerException邱ƂmFeXgP[X
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetVariableInfo03() throws Exception {
        // eXgf[^ݒ
        TagData data = null;
        // eXgs
        try {
            tag.getVariableInfo(data);
            fail();
        } catch (NullPointerException e) {
            // eXgʊmF
            return;
        }
    }

}
