/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.BeanPropertyPointer;

/**
 * nulll߂BeanvpeB|C^gNXB
 * 
 * <p>ftHgBeanvpeB|C^ł́A
 * finalw肳ĂȂNXiObject,DateAArrayListAetcj̑
 * nullĂꍇAlȂ̂ƂĈB
 * null擾ꍇA{NXgpKvB</p>
 * 
 * @see jp.terasoluna.fw.beans.jxpath.BeanPointerFactoryEx
 */
public class BeanPropertyPointerEx extends BeanPropertyPointer {

    /**
	 * VAo[WIDB
	 */
	private static final long serialVersionUID = -4617365154553497991L;

	/**
     * RXgN^B
     * @param parent eƂȂBean|C^
     * @param beanInfo ^[QbgBean̏
     */
    public BeanPropertyPointerEx(NodePointer parent, JXPathBeanInfo beanInfo) {
        super(parent, beanInfo);
    }

    /**
     * vf擾B
     * @return vf
     */
    @Override
    public int getLength() {
        int length = super.getLength();
        
        // vf̒lnull̏ꍇAvfPƂ
        if (length == 0 && getBaseValue() == null) { 
            return 1;
        }
        return length;
    }
    
    /**
     * z񂩂ǂfB
     * null̏ꍇAzƂ݂͂ȂȂB
     * @return z̏ꍇAtrueԂBȊOfalseԂB
     */
    @Override
    public boolean isCollection() {
        if (getBaseValue() == null) {
        	return false;
        }
        return super.isCollection();
    }
}
