/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.service.rich;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.StoredProcedureDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.service.rich.AbstractBLogic;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.service.rich.AbstractBLogic}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * DAÕANZT\bhBLogic̒ۃNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.service.rich.AbstractBLogic
 */
public class AbstractBLogicTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(AbstractBLogicTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public AbstractBLogicTest(String name) {
        super(name);
    }

    /**
     * testSetQueryDAO01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() queryDAO:QueryDAOCX^X<br>
     *         () queryDAO:null<br>
     *         
     * <br>
     * ҒlF(ԕω) queryDAO:Ɠ̃CX^X<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetQueryDAO01() throws Exception {
        // O
        // QueryDAONX
        QueryDAO dao = new QueryDAOImpl01();
        
        // AbstractBLogicgNX
        AbstractBLogic blogic = new AbstractBLogic_AbstractBLogicStub01();
        UTUtil.setPrivateField(blogic, "queryDAO", null);
        
        // eXg{
        blogic.setQueryDAO(dao);

        // 
        assertSame(dao, UTUtil.getPrivateField(blogic, "queryDAO"));
    }

    /**
     * testGetQueryDAO01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () queryDAO:QueryDAOCX^X<br>
     *         
     * <br>
     * ҒlF(߂l) QueryDAO:Ɠ̃CX^X<br>
     *         
     * <br>
     * ɐݒ肳Ăl𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetQueryDAO01() throws Exception {
        // O
        // QueryDAONX
        QueryDAO dao = new QueryDAOImpl01();
        
        // AbstractBLogicgNX
        AbstractBLogic blogic = new AbstractBLogic_AbstractBLogicStub01();
        UTUtil.setPrivateField(blogic, "queryDAO", dao);
        
        // eXg{
        QueryDAO getDao = blogic.getQueryDAO();

        // 
        assertSame(dao, getDao);
    }

    /**
     * testSetUpdateDAO01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() updateDAO:UpdateDAOCX^X<br>
     *         () updateDAO:null<br>
     *         
     * <br>
     * ҒlF(ԕω) updateDAO:Ɠ̃CX^X<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetUpdateDAO01() throws Exception {
        // O
        // UpdateDAONX
        UpdateDAO dao = new UpdateDAOImpl01();
        
        // AbstractBLogicgNX
        AbstractBLogic blogic = new AbstractBLogic_AbstractBLogicStub01();
        UTUtil.setPrivateField(blogic, "updateDAO", null);
        
        // eXg{
        blogic.setUpdateDAO(dao);

        // 
        assertSame(dao, UTUtil.getPrivateField(blogic, "updateDAO"));
    }

    /**
     * testGetUpdateDAO01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () updateDAO:UpdateDAOCX^X<br>
     *         
     * <br>
     * ҒlF(߂l) UpdateDAO:Ɠ̃CX^X<br>
     *         
     * <br>
     * ɐݒ肳Ăl𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetUpdateDAO01() throws Exception {
        // O
        // UpdateDAONX
        UpdateDAO dao = new UpdateDAOImpl01();
        
        // AbstractBLogicgNX
        AbstractBLogic blogic = new AbstractBLogic_AbstractBLogicStub01();
        UTUtil.setPrivateField(blogic, "updateDAO", dao);
        
        // eXg{
        UpdateDAO getDao = blogic.getUpdateDAO();

        // 
        assertSame(dao, getDao);
    }

    /**
     * testSetStoredProcedureDAO01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() storedProcedureDAO:storedProcedureDAOCX^X<br>
     *         () storedProcedureDAO:null<br>
     *         
     * <br>
     * ҒlF(ԕω) storedProcedureDAO:Ɠ̃CX^X<br>
     *         
     * <br>
     * ̒l𐳏ɑɐݒ肷邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetStoredProcedureDAO01() throws Exception {
        // O
        // StoredProcedureDAONX
        StoredProcedureDAO dao = new StoredProcedureDAOImpl01();
        
        // AbstractBLogicgNX
        AbstractBLogic blogic = new AbstractBLogic_AbstractBLogicStub01();
        UTUtil.setPrivateField(blogic, "storedProcedureDAO", null);
        
        // eXg{
        blogic.setStoredProcedureDAO(dao);

        // 
        assertSame(dao, UTUtil.getPrivateField(blogic, "storedProcedureDAO"));
    }

    /**
     * testGetStoredProcedureDAO01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() Ȃ:|<br>
     *         () storedProcedureDAO:storedProcedureDAOCX^X<br>
     *         
     * <br>
     * ҒlF(߂l) StoredProcedureDAO:Ɠ̃CX^X<br>
     *         
     * <br>
     * ɐݒ肳Ăl𐳏Ɏ擾邱ƁB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetStoredProcedureDAO01() throws Exception {
        // O
        // StoredProcedureDAONX
        StoredProcedureDAO dao = new StoredProcedureDAOImpl01();
        
        // AbstractBLogicgNX
        AbstractBLogic blogic = new AbstractBLogic_AbstractBLogicStub01();
        UTUtil.setPrivateField(blogic, "storedProcedureDAO", dao);
        
        // eXg{
        StoredProcedureDAO getDao = blogic.getStoredProcedureDAO();

        // 
        assertSame(dao, getDao);
    }
}