/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.tutorial.service.blogic;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.service.rich.BLogic;
import jp.terasoluna.rich.tutorial.service.bean.ResultData;
import jp.terasoluna.rich.tutorial.service.bean.UserBean;

/**
 * ̓NXʃNXɊi[BLogicNX
 *
 */
public class SimpleBLogic implements BLogic<UserBean, ResultData> {

    /**
     * ̓NXʃNXɊi[<br>
     * PDUserBeanNX̑̒lResultDataNXɊi[B<br>
     * QDResultDataNXɊi[B<br>
     * RDResultDataNXԋpB<br>
     *
     * @param params ̓NX 
     * @return ʃNX
     */
    public ResultData execute(UserBean params) {

        // ʃNX
        ResultData result = new ResultData();

        List<UserBean> userBeanList = new ArrayList<UserBean>();

        UserBean userBean = new UserBean();
        userBean.setId(params.getId());
        userBean.setName(params.getName());
        userBean.setAge(params.getAge());
        userBean.setBirth(params.getBirth());
        userBeanList.add(userBean);

        // UserBeanNX̑̒lResultDataNXɊi[
        result.setUserBean(userBeanList);
        result.setTotalCount(userBeanList.size());
        
        return result;
    }

}
