/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.rich.functionsample.response.view;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.terasoluna.fw.web.rich.springmvc.Constants;
import jp.terasoluna.fw.web.rich.springmvc.servlet.view.filedownload.AbstractFileDownloadView;
import jp.terasoluna.rich.functionsample.response.bean.FileResponseData;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;

/**
 * t@C_E[hr[NX
 *
 */
public class FileResponseView extends AbstractFileDownloadView {
    
    /**
     * ONXB
     */
    private static Log log = 
        LogFactory.getLog(FileResponseView.class);
    
    /**
     * X|Xɐݒ肷ARec^CṽL[B
     */
    protected String contentTypeKey = "Content-Disposition";
    
    /**
     * X|Xɐݒ肷ARec^CṽvtBbNXB
     */
    protected String contentTypePrefix = "attachment;filename=";
    
    /**
     * ̓Xg[擾B
     * @param model ƖWbŇʁB
     * @param request HTTPNGXgB
     * @return ̓Xg[B
     * @throws IOException o͗OB
     */
    @Override
    protected final InputStream getInputStream(
            Map model, HttpServletRequest request) throws IOException {
        
        // \[X擾
        Resource resource = getResource(getFileDownloadModel(model), request);
             
        try {
            return resource.getInputStream();
        } catch (IOException e) {
            log.error("Cannnot get InputStream.");
            throw e;
        }
    }

    /**
     * _E[hΏۂ̃\[X擾B
     * t@CpXŕ\郊\[X擾B
     * t@Cݒ肳ĂȂꍇAOB
     * @param fdlModel FileDownloadModelCX^XB
     * @param request HTTPNGXgB
     * @return _E[hΏۂ̃\[XB
     * @throws IOException o͗OB
     */
    protected Resource getResource(
            FileResponseData fdlModel, HttpServletRequest request) 
            throws IOException {
        if (fdlModel == null) {
            log.error("FileResponseOutputData is null!");
            throw new IllegalArgumentException(
                    "FileResponseOutputData is null!");
        }
        
        if (fdlModel.getDirectoryName() == null) {
            log.error("DirectoryName is Null.");
            throw new IllegalArgumentException("DirectoryName is Empty.");
        }
        
        if (!StringUtils.hasText(fdlModel.getFileName())) {
            log.error("FileName is Empty.");
            throw new IllegalArgumentException("FileName is Empty.");
        }
        
        // t@CpX
        String location = fdlModel.getDirectoryName() + File.separator
            + fdlModel.getFileName(); 
        
        // \[X̓ǂ݂
        return new FileSystemResourceLoader().getResource(location);
    }

    /**
     * fIuWFNgFileDownloadModelCX^X擾B
     * @param model ƖWbŇʁB
     * @return FileResponseOutputDataNX
     */
    protected FileResponseData getFileDownloadModel(Map model) {
        Object result = model.get(Constants.RESULT_KEY);
        if (result == null) {
            log.error("FileResponseOutputData Object is Null.");
            throw new IllegalStateException(
                    "FileResponseOutputData Object is Null.");
        }
        
        // {NXgpꍇAƖWbNɂFileDownloadModelԂȂĂ͂ȂȂB
        if (!(result instanceof FileResponseData)) {
            log.error(
                    "FileDownloadView must use FileResponseOutputData class!");
            throw new IllegalArgumentException(
                    "FileDownloadView must use FileResponseOutputData class!");
        }
        return (FileResponseData) result;
    }

    /**
     * X|Xwb_ǉB
     * @param model ƖWbŇʁB
     * @param request HTTPNGXgB
     * @param response HTTPX|XB
     */
    @Override
    protected final void addResponseHeader(Map model, 
            HttpServletRequest request, HttpServletResponse response) {
        
        // X|Xwb_ɐݒ肷L[ƒl̃Zbg擾
        Map<String, String> headerMap = 
            createResponseHeaderMap(getFileDownloadModel(model), request);
        
        for (String key : headerMap.keySet()) {
            response.addHeader(key, headerMap.get(key));
        }
    }
    
    /**
     * X|Xwb_ɒǉL[ƒlAMap`ō쐬B
     * @param fdlModel ƖWbNɂĕԂFileDownloadModelCX^XB
     * @param request HTTPNGXgB
     * @return X|Xwb_ɒǉL[ƒlMapB
     */
    protected Map<String, String> createResponseHeaderMap(
            FileResponseData fdlModel, HttpServletRequest request) {
        Map<String, String> headerMap = new HashMap<String, String>();
        
        // Rec^Cv
        headerMap.put(contentTypeKey, 
                contentTypePrefix + fdlModel.getFileName());
        return headerMap;
    }
}
