/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.validation.ValidationUtil;

/**
 * {@link jp.terasoluna.fw.validation.ValidationUtil} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ؃WbÑ[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.ValidationUtil
 */
public class ValidationUtilTest01 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ValidationUtilTest01.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        UTUtil.setPrivateField(ValidationUtil.class, "hankakuKanaList",
            "¯֬ܦް");
        UTUtil.setPrivateField(ValidationUtil.class, "zenkakuKanaList",
            "ACEGI@BDFHJLNPRKMOQSTVXZ\" +
            "UWY[]^`ceg_adfhijklmnqtwz" +
            "orux{psvy|}~" +
            "b[");
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ValidationUtilTest01(String name) {
        super(name);
    }

    /**
     * testSetHankakuKanaList01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list݂ȂƁB<br>
     *
     * <br>
     * ҒlF(ԕω) hankakuKanaList:¯֬ܦް<br>
     *
     * <br>
     * validation.hankaku.kana.listɒlݒ̏ꍇAhankakuKanaList̓ftHĝ܂܂ł邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetHankakuKanaList01() throws Exception {
        // eXg{
        ValidationUtil.setHankakuKanaList();

        // 
        assertEquals(
                "¯֬ܦް",
                UTUtil.getPrivateField(ValidationUtil.class, "hankakuKanaList"));
    }

    /**
     * testSetHankakuKanaList02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list=<br>
     *
     * <br>
     * ҒlF(ԕω) hankakuKanaList:<br>
     *
     * <br>
     * validation.hankaku.kana.listɒlݒ肳ĂꍇAhankakuKanaList͐ݒlƂȂ邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetHankakuKanaList02() throws Exception {
        // O
        addProperty("validation.hankaku.kana.list", "");

        // eXg{
        ValidationUtil.setHankakuKanaList();

        // 
        assertEquals("", UTUtil.getPrivateField(ValidationUtil.class,
                "hankakuKanaList"));
    }

    /**
     * testSetHankakuKanaList03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list=<br>
     *                󕶎<br>
     *
     * <br>
     * ҒlF(ԕω) hankakuKanaList:""<br>
     *
     * <br>
     * validation.hankaku.kana.listɒlݒ肳ĂꍇAhankakuKanaList͐ݒlƂȂ邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetHankakuKanaList03() throws Exception {
        // O
        addProperty("validation.hankaku.kana.list", "");

        // eXg{
        ValidationUtil.setHankakuKanaList();

        // 
        assertEquals("", UTUtil.getPrivateField(ValidationUtil.class,
                "hankakuKanaList"));
    }

    /**
     * testSetZenkakuKanaList01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list݂ȂƁB<br>
     *
     * <br>
     * ҒlF(ԕω) zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *
     * <br>
     * validation.zenkaku.kana.listɒlݒ̏ꍇAzenkakuKanaList̓ftHĝ܂܂ł邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetZenkakuKanaList01() throws Exception {
        // eXg{
        ValidationUtil.setZenkakuKanaList();

        // 
        assertEquals(
                "ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[",
                UTUtil.getPrivateField(ValidationUtil.class, "zenkakuKanaList"));
    }

    /**
     * testSetZenkakuKanaList02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list=A<br>
     *
     * <br>
     * ҒlF(ԕω) zenkakuKanaList:A<br>
     *
     * <br>
     * validation.zenkaku.kana.listɒlݒ肳ĂꍇAzenkakuKanaList͐ݒlƂȂ邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetZenkakuKanaList02() throws Exception {
        // O
        addProperty("validation.zenkaku.kana.list", "A");

        // eXg{
        ValidationUtil.setZenkakuKanaList();

        // 
        assertEquals("A", UTUtil.getPrivateField(ValidationUtil.class,
                "zenkakuKanaList"));
    }

    /**
     * testSetZenkakuKanaList03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list=<br>
     *                󕶎<br>
     *
     * <br>
     * ҒlF(ԕω) zenkakuKanaList:""<br>
     *
     * <br>
     * validation.zenkaku.kana.listɒlݒ肳ĂꍇAzenkakuKanaList͐ݒlƂȂ邱ƁB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testSetZenkakuKanaList03() throws Exception {
        // O
        addProperty("validation.zenkaku.kana.list", "");

        // eXg{
        ValidationUtil.setZenkakuKanaList();

        // 
        assertEquals("", UTUtil.getPrivateField(ValidationUtil.class,
                "zenkakuKanaList"));
    }

    /**
     * testIsHankakuKanaChar01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:¯֬ܦް<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂtrue<br>
     *
     * <br>
     * Ɏw肵hankakuKanaListɊ܂܂ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaChar01() throws Exception {
        // O
        String hankakuKanaList = "¯֬ܦް";

        // eXg{E
        for (int i = 0; i < hankakuKanaList.length(); i++) {
            assertTrue(ValidationUtil.isHankakuKanaChar(hankakuKanaList
                    .charAt(i)));
        }
    }

    /**
     * testIsHankakuKanaChar02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:''-1<br>
     *                ''+1<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂfalse<br>
     *
     * <br>
     * Ɏw肵hankakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFBipJi̋EeXgj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaChar02() throws Exception {
        // O
        char chStart = '' - 1;
        char chEnd = '' + 1;

        // eXg{E
        assertFalse(ValidationUtil.isHankakuKanaChar(chStart));
        assertFalse(ValidationUtil.isHankakuKanaChar(chEnd));
    }

    /**
     * testIsHankakuKanaChar03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'S'<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵hankakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFBiSpj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuKanaChar03() throws Exception {
        // O
        char chZenkaku = 'S';

        // eXg{E
        assertFalse(ValidationUtil.isHankakuKanaChar(chZenkaku));
    }

    /**
     * testIsHankakuChar01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'\u00ff'<br>
     *                ''<br>
     *                ''<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂtrue<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'ȉA"_Nʁ}L~"ł͂ȂAhankakuKanaListɊ܂܂ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuChar01() throws Exception {
        // O
        char chHankakuMax = '\u00ff';
        char chHankakuKanaStart = '';
        char chHankakuKanaEnd = '';

        // eXg{E
        // pݒ肳ꂽƂAtrueԋp邱
        assertTrue(ValidationUtil.isHankakuChar(chHankakuMax));
        assertTrue(ValidationUtil.isHankakuChar(chHankakuKanaStart));
        assertTrue(ValidationUtil.isHankakuChar(chHankakuKanaEnd));
    }

    /**
     * testIsHankakuChar02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'\u0100'<br>
     *                ''-1<br>
     *                ''+1<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂfalse<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'ȏA܂́A"_Nʁ}L~"Ɋ܂܂A܂́AhankakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuChar02() throws Exception {
        // O
        char chUpperff = '\u0100';
        char chKanaStart = '' - 1;
        char chKanaEnd = '' + 1;

        // eXg{E
        assertFalse(ValidationUtil.isHankakuChar(chUpperff));
        assertFalse(ValidationUtil.isHankakuChar(chKanaStart));
        assertFalse(ValidationUtil.isHankakuChar(chKanaEnd));
    }

    /**
     * testIsHankakuChar03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'A'<br>
     *                'U'<br>
     *                ''<br>
     *                ''<br>
     *                ''<br>
     *                '`'<br>
     *                'y'<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵SpłꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuChar03() throws Exception {
        // O
        char[] input = {
            'A',
            'U',
            '',
            '',
            '',
            '`',
            'y'
        };

        // eXg{E
        // Spݒ肳ꂽƂAfalseԋp邱
        for (char c : input) {
            assertFalse(ValidationUtil.isHankakuChar(c));
        }
    }

    /**
     * testIsHankakuChar04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:"_Nʁ}L~"<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'ȏA܂́A"_Nʁ}L~"Ɋ܂܂A܂́AhankakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsHankakuChar04() throws Exception {
        // O
        String zenkakuBeginU00List = "_Nʁ}L~";

        // eXg{E
        for (int i = 0; i < zenkakuBeginU00List.length(); i++) {
            assertFalse(ValidationUtil.isHankakuChar(zenkakuBeginU00List
                    .charAt(i)));
        }
    }

    /**
     * testIsZenkakuChar01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'\u0100'<br>
     *                ''-1<br>
     *                ''+1<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂtrue<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'傫AA"_Nʁ}L~"Ɋ܂܂邩AhankakuKanaListɊ܂܂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuChar01() throws Exception {
        // O
        char chZenkakuMin = '\u0100';
        char chZenkakuKanaStart = '' - 1;
        char chZenkakuKanaEnd = '' + 1;

        // eXg{E
        // Sp񂪐ݒ肳ꂽƂAtrueԋp邱
        assertTrue(ValidationUtil.isZenkakuChar(chZenkakuMin));
        assertTrue(ValidationUtil.isZenkakuChar(chZenkakuKanaStart));
        assertTrue(ValidationUtil.isZenkakuChar(chZenkakuKanaEnd));
    }

    /**
     * testIsZenkakuChar02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'\u00ff'<br>
     *                ''<br>
     *                ''<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂfalse<br>
     *
     * <br>
     * Ɏw肵R[h'\00ff'ȉA"_Nʁ}L~"ł͂ȂAhankakuKanaListɊ܂܂ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuChar02() throws Exception {
        // O
        char chZenkakuMin = '\u00ff';
        char chZenkakuKanaStart = '';
        char chZenkakuKanaEnd = '';

        // eXg{E
        // pݒ肳ꂽƂAfalseԋp邱
        assertFalse(ValidationUtil.isZenkakuChar(chZenkakuMin));
        assertFalse(ValidationUtil.isZenkakuChar(chZenkakuKanaStart));
        assertFalse(ValidationUtil.isZenkakuChar(chZenkakuKanaEnd));
    }

    /**
     * testIsZenkakuChar03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:''<br>
     *                '6'<br>
     *                '&'<br>
     *                'a'<br>
     *                'z'<br>
     *                'A'<br>
     *                'Z'<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵płꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuChar03() throws Exception {
        // O
        char[] input = {
            '',
            '6',
            '&',
            'a',
            'z',
            'A',
            'Z'
        };

        // eXg{E
        // pݒ肳ꂽƂAfalseԋp邱
        for (char c : input) {
            assertFalse(ValidationUtil.isZenkakuChar(c));
        }
    }

    /**
     * testIsZenkakuChar04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:"_Nʁ}L~"<br>
     *                ꕶmF<br>
     *         () hankakuKanaList:¯֬ܦް<br>
     *         () vpeBt@C:validation.hankaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * Ɏw肵"_Nʁ}L~"Ɋ܂܂ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuChar04() throws Exception {
        // O
        String zenkakuBeginU00List = "_Nʁ}L~";

        // eXg{E
        for (int i = 0; i < zenkakuBeginU00List.length(); i++) {
            assertTrue(ValidationUtil.isZenkakuChar(zenkakuBeginU00List
                    .charAt(i)));
        }
    }

    /**
     * testIsZenkakuKanaChar01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *                ꕶmF<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂtrue<br>
     *
     * <br>
     * Ɏw肵zenkakuKanaListɊ܂܂ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaChar01() throws Exception {
        // O
        String zenkakuKanaList = "ACEGI@BDFHJLNPR" +
                "KMOQSTVXZ\UWY[]^`ceg" +
                "_adfhijklmnqtwzorux{" +
                "psvy|}~" +
                "b[";

        // eXg{E
        for (int i = 0; i < zenkakuKanaList.length(); i++) {
            assertTrue(ValidationUtil.isZenkakuKanaChar(zenkakuKanaList
                    .charAt(i)));
        }
    }

    /**
     * testIsZenkakuKanaChar02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:'@' - 1<br>
     *                '[' + 1<br>
     *                ꕶmF<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:SĂ̕ɂfalse<br>
     *
     * <br>
     * Ɏw肵zenkakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFBipJi̋EeXgj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaChar02() throws Exception {
        // O
        char chStart = '@' - 1;
        char chEnd = '[' + 1;

        // eXg{E
        assertFalse(ValidationUtil.isZenkakuKanaChar(chStart));
        assertFalse(ValidationUtil.isZenkakuKanaChar(chEnd));
    }

    /**
     * testIsZenkakuKanaChar03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() c:''<br>
     *         () zenkakuKanaList:ACEGI@BDFHJLNPRKMOQSTVXZ\UWY[]^`ceg_adfhijklmnqtwzorux{psvy|}~b[<br>
     *         () vpeBt@C:validation.zenkaku.kana.list<br>
     *                ݂ȂƁB<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * Ɏw肵zenkakuKanaListɊ܂܂ȂꍇAfalse擾ł邱ƂmFBiSpj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsZenkakuKanaChar03() throws Exception {
        // O
        char chHiragana = '';

        // eXg{E
        assertFalse(ValidationUtil.isZenkakuKanaChar(chHiragana));
    }

}
