/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation.springmodules;

import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorException;
import org.springmodules.validation.commons.DefaultBeanValidator;

/**
 * Spring ModulesDefaultBeanValidatorpNXB
 * 
 * <p>
 * DefaultBeanValidatoŕACommons Validatorvalidator()\bhĂяoA
 * finallycleanupValidator()\bhĂяoB
 * </p>
 * 
 * <p>
 * {NXł́AcleanupValidator()\bhI[o[ChĂB
 * ̃of[^Ƀof[gOi[ĂꍇA
 * ̗O^C̃of[gOɃbvăX[B
 * </p>
 * 
 * <p>
 * {NX́A
 * cleanupValidator̈ƂCommonsValidatorExCX^X
 * n邱ƂOƂĂB
 * CommonsValidatorExNX́A
 * DefaultValidatorFactoryExNXɂĐB
 * āA{NX𗘗pꍇ́A
 * DefaultValidatorFactoryExNXɗpȂ΂ȂȂB
 * </p>
 * 
 * <p>
 * {NX𗘗pꍇɕKvBean`t@C̐ݒɂẮA
 * DefaultValidatorFactoryExJavaDoc̋LqQƂ̂ƁB
 * </p>
 * 
 *
 */
public class DefaultBeanValidatorEx extends DefaultBeanValidator {

    /**
     * Validator̃N[Abv\bhB
     * validatoȓɔ݂ꍇValidatorExceptionX[B
     * 
     * @param validator Commons Validator
     * @throws jp.terasoluna.fw.validation.springmodules.ValidatorException 
     *          of[gO
     */
    @Override
    public void cleanupValidator(Validator validator) {
        
        // validatorCommonsValidatorEx̏ꍇ
        if (validator instanceof CommonsValidatorEx) {
            // validator̃`FbNƂO擾
            ValidatorException validatorException = 
                ((CommonsValidatorEx) validator).getValidatorException();
            // ̗Oꍇ
            if (validatorException != null) {
                throw new jp.terasoluna.fw.validation.springmodules.
                    ValidatorException(validatorException);
            }
        }
    }

}
