/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    boolean dragSent = false;

    ScrollBar() {
    }

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void createHandle(int index) {
        int[] nArray = new int[8];
        nArray[0] = OS.XmNancestorSensitive;
        nArray[1] = 1;
        nArray[2] = OS.XmNborderWidth;
        nArray[3] = (this.style & 0x800) != 0 ? 1 : 0;
        nArray[4] = OS.XmNorientation;
        nArray[5] = (this.style & 0x100) != 0 ? 2 : 1;
        nArray[6] = OS.XmNtraversalOn;
        int[] argList = nArray;
        int parentHandle = this.parent.scrolledHandle;
        this.handle = OS.XmCreateScrollBar(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNincrement;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmaximum;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNminimum;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNpageIncrement;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNvalue;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public Point getSize() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int borders = argList[5] * 2;
        return new Point(argList[1] + borders, argList[3] + borders);
    }

    public int getThumb() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsliderSize;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public boolean getVisible() {
        this.checkWidget();
        return OS.XtIsManaged(this.handle);
    }

    void hookEvents() {
        int windowProc = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, windowProc, 24);
        OS.XtAddCallback(this.handle, OS.XmNdragCallback, windowProc, 15);
        OS.XtAddCallback(this.handle, OS.XmNtoBottomCallback, windowProc, 22);
        OS.XtAddCallback(this.handle, OS.XmNtoTopCallback, windowProc, 23);
        OS.XtAddCallback(this.handle, OS.XmNincrementCallback, windowProc, 18);
        OS.XtAddCallback(this.handle, OS.XmNdecrementCallback, windowProc, 13);
        OS.XtAddCallback(this.handle, OS.XmNpageIncrementCallback, windowProc, 21);
        OS.XtAddCallback(this.handle, OS.XmNpageDecrementCallback, windowProc, 20);
        OS.XtAddEventHandler(this.handle, 4, false, windowProc, 1);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void manageChildren() {
        int scrolledHandle = this.parent.scrolledHandle;
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] argList = nArray;
        if (scrolledHandle != 0) {
            OS.XtGetValues(scrolledHandle, argList, argList.length / 2);
        }
        OS.XtManageChild(this.handle);
        if (scrolledHandle != 0) {
            OS.XtResizeWidget(scrolledHandle, argList[1], argList[3], argList[5]);
        }
    }

    void propagateWidget(boolean enabled) {
        this.propagateHandle(enabled, this.handle, 0);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void sendScrollEvent(int detail) {
        Event event = new Event();
        event.detail = detail;
        this.sendEvent(13, event);
        Shell shell = this.parent.getShell();
        shell.bringToTop(true);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNsensitive, enabled ? 1 : 0};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int[] argList = new int[]{OS.XmNincrement, value};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNmaximum, value};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        nArray[4] = OS.XmNsliderSize;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[3] - value - argList[5] < 0) {
            argList[5] = argList[3] - value;
        }
        argList[1] = value;
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int[] argList = new int[]{OS.XmNpageIncrement, value};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setSelection(int selection) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNvalue, selection};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        value = Math.min(value, argList[3] - argList[1]);
        int[] argList2 = new int[]{OS.XmNsliderSize, value};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        int[] argList = new int[]{OS.XmNvalue, selection, OS.XmNminimum, minimum, OS.XmNmaximum, maximum, OS.XmNsliderSize, thumb, OS.XmNincrement, increment, OS.XmNpageIncrement, pageIncrement};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        this.parent.setScrollBarVisible(this, visible);
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XButtonPress(w, client_data, call_data, continue_to_dispatch);
        if (result != 0) {
            return result;
        }
        this.dragSent = false;
        return result;
    }

    int XmNdecrementCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000001);
        return 0;
    }

    int XmNdragCallback(int w, int client_data, int call_data) {
        this.dragSent = true;
        this.sendScrollEvent(1);
        return 0;
    }

    int XmNincrementCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000002);
        return 0;
    }

    int XmNpageDecrementCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000005);
        return 0;
    }

    int XmNpageIncrementCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000006);
        return 0;
    }

    int XmNtoBottomCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000008);
        return 0;
    }

    int XmNtoTopCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000007);
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        if (!this.dragSent) {
            this.sendScrollEvent(1);
            this.dragSent = false;
        }
        this.sendScrollEvent(0);
        return 0;
    }
}

