/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XButtonEvent;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XCrossingEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.internal.motif.XFontStruct;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XMotionEvent;
import org.eclipse.swt.internal.motif.XSetWindowAttributes;
import org.eclipse.swt.internal.motif.XWindowChanges;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    int drawCount;
    int redrawWindow;
    Composite parent;
    Cursor cursor;
    Menu menu;
    Image backgroundImage;
    Font font;
    String toolTipText;
    Object layoutData;
    Accessible accessible;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    int borderHandle() {
        return this.topHandle();
    }

    void checkBackground() {
        Shell shell = this.getShell();
        if (this == shell) {
            return;
        }
        this.state &= 0xFFFFFFBF;
        Composite composite = this.parent;
        while (true) {
            int mode;
            if ((mode = composite.backgroundMode) != 0) {
                if (mode == 1) {
                    Control control = this;
                    do {
                        if ((control.state & 0x80) != 0) continue;
                        return;
                    } while ((control = control.parent) != composite);
                }
                this.state |= 0x40;
                return;
            }
            if (composite == shell) break;
            composite = composite.parent;
        }
    }

    void checkBuffered() {
        this.style &= 0xDFFFFFFF;
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createWidget(int index) {
        int topHandle;
        this.state |= 0x4000;
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.checkBackground();
        this.checkBuffered();
        this.setParentTraversal();
        this.overrideTranslations();
        if (!this.hasIMSupport()) {
            OS.XmImRegister(this.handle, 0);
            int focusHandle = this.focusHandle();
            if (this.handle != focusHandle) {
                OS.XmImRegister(focusHandle, 0);
            }
        }
        if (OS.XtIsRealized(topHandle = this.topHandle()) && !OS.XtIsSubclass(topHandle, OS.shellWidgetClass())) {
            int display;
            int window = OS.XtWindow(topHandle);
            if (window != 0 && (display = OS.XtDisplay(topHandle)) != 0) {
                OS.XLowerWindow(display, window);
            }
            this.realizeChildren();
        }
        OS.XtOverrideTranslations(this.handle, this.display.dragTranslations);
        this.font = this.defaultFont();
    }

    int defaultBackground() {
        return this.display.defaultBackground;
    }

    Font defaultFont() {
        return this.display.defaultFont;
    }

    int defaultForeground() {
        return this.display.defaultForeground;
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            this.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    boolean dragDetect(int button, int count, int stateMask, int x, int y) {
        if (button != 2 || count != 1) {
            return false;
        }
        if (!this.dragDetect(x, y, false, null)) {
            return false;
        }
        return this.sendDragEvent(button, stateMask, x, y, true);
    }

    boolean dragDetect(int x, int y, boolean force, boolean[] consume) {
        return true;
    }

    boolean drawGripper(int x, int y, int width, int height, boolean vertical) {
        return false;
    }

    void enableWidget(boolean enabled) {
        this.enableHandle(enabled, this.handle);
    }

    Control findBackgroundControl() {
        if ((this.state & 0x10) != 0 || this.backgroundImage != null) {
            return this;
        }
        return (this.state & 0x40) != 0 ? this.parent.findBackgroundControl() : null;
    }

    char findMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    void fixFocus(Control focusControl) {
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell && (control = control.parent) != null) {
            if (!control.setFocus()) continue;
            return;
        }
        shell.setSavedFocus(focusControl);
    }

    int focusHandle() {
        return this.handle;
    }

    int fontHandle() {
        return this.handle;
    }

    public boolean forceFocus() {
        boolean force;
        this.checkWidget();
        if (this.display.focusEvent == 16) {
            return false;
        }
        Decorations shell = this.menuShell();
        shell.setSavedFocus(this);
        shell.bringToTop(false);
        int focusHandle = this.focusHandle();
        if (this.handle != focusHandle) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNnumChildren;
            int[] argList1 = nArray;
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            if (argList1[1] > 1) {
                int[] nArray2 = new int[2];
                nArray2[0] = OS.XmNtraversalOn;
                int[] argList = nArray2;
                OS.XtGetValues(focusHandle, argList, argList.length / 2);
                if (argList[1] == 0) {
                    argList[1] = 1;
                    OS.XtSetValues(focusHandle, argList, argList.length / 2);
                    this.overrideTranslations();
                }
            } else {
                focusHandle = this.handle;
            }
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtraversalOn;
        int[] argList = nArray;
        OS.XtGetValues(focusHandle, argList, argList.length / 2);
        boolean bl = force = argList[1] == 0;
        if (force) {
            this.state |= 8;
            argList[1] = 1;
            OS.XtSetValues(focusHandle, argList, argList.length / 2);
            this.overrideTranslations();
        }
        if (this.XmProcessTraversal(focusHandle, 0)) {
            return true;
        }
        if (force) {
            this.state &= 0xFFFFFFF7;
            argList[1] = 0;
            OS.XtSetValues(focusHandle, argList, argList.length / 2);
        }
        return false;
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return Color.motif_new(this.display, this.getXColor(control.getBackgroundPixel()));
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        Control control = this.findBackgroundControl();
        if (control == null) {
            control = this;
        }
        return control.backgroundImage;
    }

    int getBackgroundPixel() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNbackground;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getBorderWidth() {
        this.checkWidget();
        int borderHandle = this.borderHandle();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNborderWidth;
        int[] argList = nArray;
        OS.XtGetValues(borderHandle, argList, argList.length / 2);
        return argList[1];
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] nArray = new int[10];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        nArray[4] = OS.XmNwidth;
        nArray[6] = OS.XmNheight;
        nArray[8] = OS.XmNborderWidth;
        int[] argList = nArray;
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        int borders = argList[9] * 2;
        return new Rectangle((short)argList[1], (short)argList[3], argList[5] + borders, argList[7] + borders);
    }

    Point getClientLocation() {
        short[] handle_x = new short[1];
        short[] handle_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, handle_x, handle_y);
        short[] topHandle_x = new short[1];
        short[] topHandle_y = new short[1];
        OS.XtTranslateCoords(this.parent.handle, (short)0, (short)0, topHandle_x, topHandle_y);
        return new Point(handle_x[0] - topHandle_x[0], handle_y[0] - topHandle_y[0]);
    }

    String getCodePage() {
        return this.font.codePage;
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return (this.state & 0x4000) != 0;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsensitive;
        int[] argList = nArray;
        OS.XtGetValues(this.topHandle(), argList, argList.length / 2);
        return argList[1] != 0;
    }

    public Font getFont() {
        this.checkWidget();
        return this.font;
    }

    int getFontAscent(int font) {
        int fontListEntry;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, font)) {
            this.error(2);
        }
        int context = buffer[0];
        int ascent = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                if (fontStruct.ascent <= ascent) continue;
                ascent = fontStruct.ascent;
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                if (fontStruct.ascent > ascent) {
                    ascent = fontStruct.ascent;
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return ascent;
    }

    int getFontHeight(int font) {
        int fontListEntry;
        int[] buffer = new int[1];
        if (!OS.XmFontListInitFontContext(buffer, font)) {
            this.error(2);
        }
        int context = buffer[0];
        int height = 0;
        XFontStruct fontStruct = new XFontStruct();
        int[] fontStructPtr = new int[1];
        int[] fontNamePtr = new int[1];
        while ((fontListEntry = OS.XmFontListNextEntry(context)) != 0) {
            int fontPtr = OS.XmFontListEntryGetFont(fontListEntry, buffer);
            if (buffer[0] == 0) {
                OS.memmove(fontStruct, fontPtr, 80);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                if (fontHeight <= height) continue;
                height = fontHeight;
                continue;
            }
            int nFonts = OS.XFontsOfFontSet(fontPtr, fontStructPtr, fontNamePtr);
            int[] fontStructs = new int[nFonts];
            OS.memmove(fontStructs, fontStructPtr[0], nFonts * 4);
            int i = 0;
            while (i < nFonts) {
                OS.memmove(fontStruct, fontStructs[i], 80);
                int fontHeight = fontStruct.ascent + fontStruct.descent;
                if (fontHeight > height) {
                    height = fontHeight;
                }
                ++i;
            }
        }
        OS.XmFontListFreeFontContext(context);
        return height;
    }

    public Color getForeground() {
        this.checkWidget();
        return Color.motif_new(this.display, this.getXColor(this.getForegroundPixel()));
    }

    int getForegroundPixel() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNforeground;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    Caret getIMCaret() {
        return null;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] nArray = new int[4];
        nArray[0] = OS.XmNx;
        nArray[2] = OS.XmNy;
        int[] argList = nArray;
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        return new Point((short)argList[1], (short)argList[3]);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    int getMinimumHeight() {
        return 0;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors.length == 1) {
            return monitors[0];
        }
        int index = -1;
        int value = -1;
        Rectangle bounds = this.getBounds();
        if (this != this.getShell()) {
            bounds = this.display.map((Control)this.parent, null, bounds);
        }
        int i = 0;
        while (i < monitors.length) {
            Rectangle rect = bounds.intersection(monitors[i].getBounds());
            int area = rect.width * rect.height;
            if (area > 0 && area > value) {
                index = i;
                value = area;
            }
            ++i;
        }
        if (index >= 0) {
            return monitors[index];
        }
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        int i2 = 0;
        while (i2 < monitors.length) {
            int x;
            Rectangle rect = monitors[i2].getBounds();
            int n = centerX < rect.x ? rect.x - centerX : (x = centerX > rect.x + rect.width ? centerX - rect.x - rect.width : 0);
            int y = centerY < rect.y ? rect.y - centerY : (centerY > rect.y + rect.height ? centerY - rect.y - rect.height : 0);
            int distance = x * x + y * y;
            if (index == -1 || distance < value) {
                index = i2;
                value = distance;
            }
            ++i2;
        }
        return monitors[index];
    }

    int getNavigationType() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNnavigationType;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public Point getSize() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] argList = nArray;
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        int borders = argList[5] * 2;
        return new Point(argList[1] + borders, argList[3] + borders);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public boolean getVisible() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmappedWhenManaged;
        int[] argList = nArray;
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        return argList[1] != 0;
    }

    XColor getXColor(int pixel) {
        int display = OS.XtDisplay(this.handle);
        if (display == 0) {
            return null;
        }
        int[] nArray = new int[2];
        nArray[0] = OS.XmNcolormap;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        int colormap = argList[1];
        if (colormap == 0) {
            return null;
        }
        XColor color = new XColor();
        color.pixel = pixel;
        OS.XQueryColor(display, colormap, color);
        return color;
    }

    boolean hasFocus() {
        return this == this.display.getFocusControl();
    }

    boolean hasIMSupport() {
        return false;
    }

    void hookEvents() {
        int windowProc = this.display.windowProc;
        OS.XtAddEventHandler(this.handle, 4, false, windowProc, 1);
        OS.XtAddEventHandler(this.handle, 8, false, windowProc, 2);
        OS.XtAddEventHandler(this.handle, 64, false, windowProc, 26);
        OS.XtAddEventHandler(this.handle, 16, false, windowProc, 4);
        OS.XtAddEventHandler(this.handle, 32, false, windowProc, 8);
        OS.XtInsertEventHandler(this.handle, 32768, false, windowProc, 3, 1);
        OS.XtAddCallback(this.handle, OS.XmNhelpCallback, windowProc, 17);
        OS.XtAddEventHandler(this.handle, 1, false, windowProc, 6);
        OS.XtAddEventHandler(this.handle, 2, false, windowProc, 7);
        OS.XtInsertEventHandler(this.handle, 0x200000, false, windowProc, 5, 1);
        int focusHandle = this.focusHandle();
        if (this.handle != focusHandle) {
            OS.XtAddEventHandler(focusHandle, 1, false, windowProc, 6);
            OS.XtAddEventHandler(focusHandle, 2, false, windowProc, 7);
            OS.XtInsertEventHandler(focusHandle, 0x200000, false, windowProc, 5, 1);
        }
    }

    int hoverProc(int id) {
        return this.hoverProc(id, true);
    }

    int hoverProc(int id, boolean showTip) {
        if (showTip) {
            this.display.showToolTip(this.handle, this.toolTipText);
        }
        this.sendMouseEvent(32);
        return 0;
    }

    public int internal_new_GC(GCData data) {
        int xGC;
        int xWindow;
        int xDisplay;
        this.checkWidget();
        if (!OS.XtIsRealized(this.handle)) {
            Shell shell = this.getShell();
            shell.realizeWidget();
        }
        if ((xDisplay = OS.XtDisplay(this.handle)) == 0) {
            SWT.error(2);
        }
        if ((xWindow = OS.XtWindow(this.handle)) == 0) {
            SWT.error(2);
        }
        if ((xGC = OS.XCreateGC(xDisplay, xWindow, 0, null)) == 0) {
            SWT.error(2);
        }
        OS.XSetGraphicsExposures(xDisplay, xGC, false);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= this.style & (mask | 0x8000000);
            }
            data.device = this.display;
            data.display = xDisplay;
            data.drawable = xWindow;
            XColor foreground = new XColor();
            foreground.pixel = this.getForegroundPixel();
            data.foreground = foreground;
            Control control = this.findBackgroundControl();
            if (control == null) {
                control = this;
            }
            XColor background = new XColor();
            background.pixel = control.getBackgroundPixel();
            data.background = background;
            data.backgroundImage = control.backgroundImage;
            data.font = this.font;
            int[] nArray = new int[2];
            nArray[0] = OS.XmNcolormap;
            int[] argList = nArray;
            OS.XtGetValues(this.handle, argList, argList.length / 2);
            data.colormap = argList[1];
        }
        return xGC;
    }

    public void internal_dispose_GC(int xGC, GCData data) {
        this.checkWidget();
        int xDisplay = 0;
        if (data != null) {
            xDisplay = data.display;
        }
        if (xDisplay == 0 && this.handle != 0) {
            xDisplay = OS.XtDisplay(this.handle);
        }
        if (xDisplay == 0) {
            SWT.error(2);
        }
        OS.XFreeGC(xDisplay, xGC);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isFocusAncestor(Control control) {
        while (control != null && control != this && !(control instanceof Shell)) {
            control = control.parent;
        }
        return control == this;
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 1 || size.y == 1) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void manageChildren() {
        OS.XtSetMappedWhenManaged(this.handle, false);
        OS.XtManageChild(this.handle);
        int[] nArray = new int[2];
        nArray[0] = OS.XmNborderWidth;
        int[] argList3 = nArray;
        OS.XtGetValues(this.handle, argList3, argList3.length / 2);
        OS.XtResizeWidget(this.handle, 1, 1, argList3[1]);
        OS.XtSetMappedWhenManaged(this.handle, true);
    }

    void markLayout(boolean changed, boolean all) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    boolean mnemonicHit(char key) {
        return false;
    }

    boolean mnemonicMatch(char key) {
        return false;
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, true);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (this.parent != control.parent) {
                return;
            }
        }
        this.setZOrder(control, false);
    }

    void overrideTranslations() {
        OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
        OS.XtOverrideTranslations(this.handle, this.display.arrowTranslations);
        int focusHandle = this.focusHandle();
        if (this.handle != focusHandle) {
            OS.XtOverrideTranslations(focusHandle, this.display.tabTranslations);
            OS.XtOverrideTranslations(focusHandle, this.display.arrowTranslations);
        }
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    void propagateChildren(boolean enabled) {
        this.propagateWidget(enabled);
    }

    void propagateWidget(boolean enabled) {
        int xCursor = enabled && this.cursor != null ? this.cursor.handle : 0;
        this.propagateHandle(enabled, this.handle, xCursor);
    }

    void realizeChildren() {
        if (this.isEnabled()) {
            if (this.cursor != null) {
                int xWindow = OS.XtWindow(this.handle);
                if (xWindow == 0) {
                    return;
                }
                int xDisplay = OS.XtDisplay(this.handle);
                if (xDisplay == 0) {
                    return;
                }
                OS.XDefineCursor(xDisplay, xWindow, this.cursor.handle);
                OS.XFlush(xDisplay);
            }
        } else {
            this.propagateWidget(false);
        }
        if ((this.state & 0x40) != 0) {
            this.setParentBackground();
        }
    }

    public void redraw() {
        this.checkWidget();
        this.redrawWidget(0, 0, 0, 0, true, false, false);
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        if (width > 0 && height > 0) {
            this.redrawWidget(x, y, width, height, false, all, false);
        }
    }

    void redrawChildren() {
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean allChildren, boolean trim) {
        this.redrawHandle(x, y, width, height, redrawAll, this.handle);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        int fontList = this.defaultFont().handle;
        if (this.font.handle != fontList) {
            int fontHandle = this.fontHandle();
            int[] argList2 = new int[]{OS.XmNfontList, fontList};
            OS.XtSetValues(fontHandle, argList2, argList2.length / 2);
            OS.XmImSetValues(fontHandle, argList2, argList2.length / 2);
        }
        this.display.releaseToolTipHandle(this.handle);
        this.toolTipText = null;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        if (!this.hasIMSupport()) {
            OS.XmImUnregister(this.handle);
            int focusHandle = this.focusHandle();
            if (this.handle != focusHandle) {
                OS.XmImUnregister(focusHandle);
            }
        }
        this.layoutData = null;
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    boolean sendDragEvent(int button, int stateMask, int x, int y, boolean isStateMask) {
        Event event = new Event();
        event.button = button;
        event.x = x;
        event.y = y;
        if (isStateMask) {
            event.stateMask = stateMask;
        } else {
            this.setInputState(event, stateMask);
        }
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendFocusEvent(int type) {
        Display display = this.display;
        if (type == 15) {
            Combo focusedCombo = display.focusedCombo;
            display.focusedCombo = null;
            if (focusedCombo != null && focusedCombo != this && !focusedCombo.isDisposed()) {
                display.sendFocusEvent(focusedCombo, 16);
            }
        }
        display.sendFocusEvent(this, type);
    }

    void sendHelpEvent(int callData) {
        Control control = this;
        while (control != null) {
            if (control.hooks(28)) {
                control.postEvent(28);
                return;
            }
            control = control.parent;
        }
    }

    boolean sendMouseEvent(int type) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        int xWindow = OS.XtWindow(this.handle);
        int[] windowX = new int[1];
        int[] windowY = new int[1];
        int[] mask = new int[1];
        int[] unused = new int[1];
        OS.XQueryPointer(xDisplay, xWindow, unused, unused, unused, unused, windowX, windowY, mask);
        return this.sendMouseEvent(type, 0, 0, 0, false, 0, windowX[0], windowY[0], mask[0]);
    }

    boolean sendMouseEvent(int type, int button, int count, int detail, boolean send, int time, int x, int y, int state) {
        Event event = new Event();
        event.time = time;
        event.button = button;
        event.count = count;
        event.detail = detail;
        event.x = x;
        event.y = y;
        this.setInputState(event, state);
        if (send) {
            this.sendEvent(type, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(type, event);
        }
        return event.doit;
    }

    boolean sendMouseEvent(int type, XButtonEvent xEvent) {
        int button = xEvent.button;
        switch (button) {
            case 4: 
            case 5: {
                if (type != 3) {
                    return true;
                }
                type = 37;
                if (!this.hooks(type) && !this.filters(type)) {
                    return true;
                }
                short[] x_root = new short[1];
                short[] y_root = new short[1];
                OS.XtTranslateCoords(this.handle, (short)0, (short)0, x_root, y_root);
                int x = xEvent.x_root - x_root[0];
                int y = xEvent.y_root - y_root[0];
                int count = button == 4 ? 3 : -3;
                Control control = this;
                Shell shell = this.getShell();
                do {
                    if (!control.sendMouseEvent(type, 0, count, 1, true, xEvent.time, x, y, xEvent.state)) {
                        return false;
                    }
                    if (control == shell) break;
                    control = control.parent;
                    OS.XtTranslateCoords(control.handle, (short)0, (short)0, x_root, y_root);
                    x = xEvent.x_root - x_root[0];
                    y = xEvent.y_root - y_root[0];
                } while (control != null);
                return true;
            }
            case 6: {
                button = 4;
                break;
            }
            case 7: {
                button = 5;
            }
        }
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        short[] x_root = new short[1];
        short[] y_root = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, x_root, y_root);
        int x = xEvent.x_root - x_root[0];
        int y = xEvent.y_root - y_root[0];
        return this.sendMouseEvent(type, button, this.display.clickCount, 0, false, xEvent.time, x, y, xEvent.state);
    }

    boolean sendMouseEvent(int type, XCrossingEvent xEvent) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        short[] x_root = new short[1];
        short[] y_root = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, x_root, y_root);
        int x = xEvent.x_root - x_root[0];
        int y = xEvent.y_root - y_root[0];
        return this.sendMouseEvent(type, 0, 0, 0, false, xEvent.time, x, y, xEvent.state);
    }

    boolean sendMouseEvent(int type, XMotionEvent xEvent) {
        if (!this.hooks(type) && !this.filters(type)) {
            return true;
        }
        short[] x_root = new short[1];
        short[] y_root = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, x_root, y_root);
        int x = xEvent.x_root - x_root[0];
        int y = xEvent.y_root - y_root[0];
        return this.sendMouseEvent(type, 0, 0, 0, false, xEvent.time, x, y, xEvent.state);
    }

    void setBackground() {
        if ((this.state & 0x40) != 0 && (this.state & 0x10) == 0 && this.backgroundImage == null) {
            this.setParentBackground();
        } else if (this.backgroundImage != null) {
            int[] argList = new int[]{OS.XmNbackgroundPixmap, this.backgroundImage.pixmap};
            OS.XtSetValues(this.handle, argList, argList.length / 2);
        } else {
            int pixel = this.getBackgroundPixel();
            this.setBackgroundPixel(pixel + 1);
            this.setBackgroundPixel(pixel);
        }
        this.redrawWidget(0, 0, 0, 0, true, false, false);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color == null) {
            this.state &= 0xFFFFFFEF;
            this.setBackgroundPixel(this.defaultBackground());
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            this.state |= 0x10;
            this.setBackgroundPixel(color.handle.pixel);
        }
        if ((this.state & 0x40) != 0 && (this.state & 0x10) == 0 && this.backgroundImage == null) {
            this.setParentBackground();
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
        this.redrawChildren();
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error(5);
        }
        if (image == this.backgroundImage) {
            return;
        }
        this.backgroundImage = image;
        int pixmap = image != null ? image.pixmap : 2;
        int[] argList = new int[]{OS.XmNbackgroundPixmap, pixmap};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        if ((this.state & 0x40) != 0 && (this.state & 0x10) == 0 && this.backgroundImage == null) {
            this.setParentBackground();
            this.redrawWidget(0, 0, 0, 0, true, false, false);
        }
        this.redrawChildren();
    }

    void setBackgroundPixel(int pixel) {
        int[] nArray = new int[4];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNhighlightColor;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        OS.XmChangeColor(this.handle, pixel);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int topHandle = this.topHandle();
        if (move && resize) {
            boolean sameExtent;
            int[] nArray = new int[10];
            nArray[0] = OS.XmNx;
            nArray[2] = OS.XmNy;
            nArray[4] = OS.XmNwidth;
            nArray[6] = OS.XmNheight;
            nArray[8] = OS.XmNborderWidth;
            int[] argList = nArray;
            OS.XtGetValues(topHandle, argList, argList.length / 2);
            width = Math.max(width - argList[9] * 2, 1);
            height = Math.max(height - argList[9] * 2, 1);
            boolean sameOrigin = x == (short)argList[1] && y == (short)argList[3];
            boolean bl = sameExtent = width == argList[5] && height == argList[7];
            if (sameOrigin && sameExtent) {
                return false;
            }
            if (this.redrawWindow != 0) {
                int xDisplay = OS.XtDisplay(this.handle);
                OS.XResizeWindow(xDisplay, this.redrawWindow, width, height);
            }
            OS.XtConfigureWidget(topHandle, x, y, width, height, argList[9]);
            this.updateIM();
            if (!sameOrigin) {
                Control control = this.findBackgroundControl();
                if (control != null && control.backgroundImage != null && this.isVisible()) {
                    this.redrawWidget(0, 0, 0, 0, true, true, true);
                }
                this.sendEvent(10);
            }
            if (!sameExtent) {
                this.sendEvent(11);
            }
            return true;
        }
        if (move) {
            int[] nArray = new int[4];
            nArray[0] = OS.XmNx;
            nArray[2] = OS.XmNy;
            int[] argList = nArray;
            OS.XtGetValues(topHandle, argList, argList.length / 2);
            if (x == (short)argList[1] && y == (short)argList[3]) {
                return false;
            }
            OS.XtMoveWidget(topHandle, x, y);
            Control control = this.findBackgroundControl();
            if (control != null && control.backgroundImage != null && this.isVisible()) {
                this.redrawWidget(0, 0, 0, 0, true, true, true);
            }
            this.sendEvent(10);
            return true;
        }
        if (resize) {
            int[] nArray = new int[6];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            nArray[4] = OS.XmNborderWidth;
            int[] argList = nArray;
            OS.XtGetValues(topHandle, argList, argList.length / 2);
            width = Math.max(width - argList[5] * 2, 1);
            height = Math.max(height - argList[5] * 2, 1);
            if (width == argList[1] && height == argList[3]) {
                return false;
            }
            if (this.redrawWindow != 0) {
                int xDisplay = OS.XtDisplay(this.handle);
                OS.XResizeWindow(xDisplay, this.redrawWindow, width, height);
            }
            OS.XtResizeWidget(topHandle, width, height, argList[5]);
            this.updateIM();
            this.sendEvent(11);
            return true;
        }
        return false;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, Math.max(0, width), Math.max(0, height), true, true);
    }

    public void setBounds(Rectangle rect) {
        this.checkWidget();
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
        int display = OS.XtDisplay(this.handle);
        if (display == 0) {
            return;
        }
        if (capture) {
            int window = OS.XtWindow(this.handle);
            if (window == 0) {
                return;
            }
            OS.XGrabPointer(display, window, 0, 76, 1, 1, 0, 0, 0);
        } else {
            OS.XUngrabPointer(display, 0);
        }
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        if (cursor != null && cursor.isDisposed()) {
            this.error(5);
        }
        this.cursor = cursor;
        if (!this.isEnabled() && this != this.getShell()) {
            return;
        }
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return;
        }
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return;
        }
        if (cursor == null) {
            OS.XUndefineCursor(xDisplay, xWindow);
        } else {
            if (cursor.isDisposed()) {
                SWT.error(5);
            }
            OS.XDefineCursor(xDisplay, xWindow, cursor.handle);
        }
        OS.XFlush(xDisplay);
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
        this.state = dragDetect ? (this.state |= 0x4000) : (this.state &= 0xFFFFBFFF);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled == this.getEnabled()) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!enabled && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        this.enableWidget(enabled);
        if (fixFocus) {
            this.fixFocus(control);
        }
        if (!enabled || this.isEnabled() && enabled) {
            this.propagateChildren(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font == null) {
            font = this.defaultFont();
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
        this.font = font;
        int[] nArray = new int[6];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        nArray[4] = OS.XmNborderWidth;
        int[] argList1 = nArray;
        OS.XtGetValues(this.handle, argList1, argList1.length / 2);
        int fontHandle = this.fontHandle();
        int[] argList2 = new int[]{OS.XmNfontList, font.handle};
        OS.XtSetValues(fontHandle, argList2, argList2.length / 2);
        this.updateIM();
        OS.XtResizeWidget(this.handle, argList1[1], argList1[3], argList1[5]);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color == null) {
            this.state &= 0xFFFFFFDF;
            this.setForegroundPixel(this.defaultForeground());
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            this.state |= 0x20;
            this.setForegroundPixel(color.handle.pixel);
        }
    }

    void setForegroundPixel(int pixel) {
        int[] argList = new int[]{OS.XmNforeground, pixel};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setBounds(location.x, location.y, 0, 0, true, false);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            if ((menu.style & 8) == 0) {
                this.error(37);
            }
            if (menu.parent != this.menuShell()) {
                this.error(32);
            }
        }
        this.menu = menu;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        return false;
    }

    void setParentBackground() {
        this.setParentBackground(this.handle);
    }

    void setParentBackground(int widget) {
        int xDisplay = OS.XtDisplay(widget);
        if (xDisplay == 0) {
            return;
        }
        int xWindow = OS.XtWindow(widget);
        if (xWindow == 0) {
            return;
        }
        OS.XSetWindowBackgroundPixmap(xDisplay, xWindow, 1);
    }

    void setParentTraversal() {
        if ((this.parent.style & 0x80000) != 0) {
            int parentHandle = this.parent.handle;
            int[] nArray = new int[2];
            nArray[0] = OS.XmNtraversalOn;
            int[] argList = nArray;
            OS.XtGetValues(parentHandle, argList, argList.length / 2);
            if (argList[1] == 0) {
                argList[1] = 1;
                OS.XtSetValues(parentHandle, argList, argList.length / 2);
                this.parent.overrideTranslations();
            }
        }
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            if (--this.drawCount == 0 && this.redrawWindow != 0) {
                int xDisplay = OS.XtDisplay(this.handle);
                if (xDisplay == 0) {
                    return;
                }
                int xWindow = OS.XtWindow(this.handle);
                if (xWindow == 0) {
                    return;
                }
                OS.XDestroyWindow(xDisplay, this.redrawWindow);
                OS.XSelectInput(xDisplay, xWindow, OS.XtBuildEventMask(this.handle));
                this.redrawWindow = 0;
            }
        } else if (this.drawCount++ == 0) {
            int xDisplay = OS.XtDisplay(this.handle);
            if (xDisplay == 0) {
                return;
            }
            int xWindow = OS.XtWindow(this.handle);
            if (xWindow == 0) {
                return;
            }
            Rectangle rect = this.getBounds();
            XSetWindowAttributes attributes = new XSetWindowAttributes();
            attributes.background_pixmap = 0;
            attributes.event_mask = 32768;
            int mask = 6145;
            this.redrawWindow = OS.XCreateWindow(xDisplay, xWindow, 0, 0, rect.width, rect.height, 0, 0, 0, 0, mask, attributes);
            if (this.redrawWindow != 0) {
                int mouseMask = 16364;
                OS.XSelectInput(xDisplay, xWindow, OS.XtBuildEventMask(this.handle) & ~mouseMask);
                OS.XRaiseWindow(xDisplay, this.redrawWindow);
                OS.XMapWindow(xDisplay, this.redrawWindow);
            }
        }
    }

    boolean setTabGroupFocus(boolean next) {
        return this.setTabItemFocus(next);
    }

    boolean setTabItemFocus(boolean next) {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, Math.max(0, width), Math.max(0, height), false, true);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setBounds(0, 0, size.x, size.y, false, true);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        this.display.setToolTipText(this.handle, this.toolTipText);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmappedWhenManaged;
        int[] argList = nArray;
        OS.XtGetValues(topHandle, argList, argList.length / 2);
        if (argList[1] != 0 == visible) {
            return;
        }
        Control control = null;
        boolean fixFocus = false;
        if (!visible && this.display.focusEvent != 16) {
            control = this.display.getFocusControl();
            fixFocus = this.isFocusAncestor(control);
        }
        OS.XtSetMappedWhenManaged(topHandle, visible);
        if (fixFocus) {
            this.fixFocus(control);
        }
        if (this.isDisposed()) {
            return;
        }
        this.sendEvent(visible ? 22 : 23);
    }

    void setZOrder(Control control, boolean above) {
        this.setZOrder(control, above, true);
    }

    void setZOrder(Control control, boolean above, boolean fixChildren) {
        int window2;
        int redrawWindow;
        int window1;
        int topHandle1 = this.topHandle();
        int display = OS.XtDisplay(topHandle1);
        if (display == 0) {
            return;
        }
        if (!OS.XtIsRealized(topHandle1)) {
            Shell shell = this.getShell();
            shell.realizeWidget();
        }
        if ((window1 = OS.XtWindow(topHandle1)) == 0) {
            return;
        }
        int n = redrawWindow = fixChildren ? this.parent.redrawWindow : 0;
        if (!(control != null || above && redrawWindow != 0)) {
            if (above) {
                OS.XRaiseWindow(display, window1);
                if (fixChildren) {
                    this.parent.moveAbove(topHandle1, 0);
                }
            } else {
                OS.XLowerWindow(display, window1);
                if (fixChildren) {
                    this.parent.moveBelow(topHandle1, 0);
                }
            }
            return;
        }
        int topHandle2 = 0;
        if (control != null) {
            topHandle2 = control.topHandle();
            if (display != OS.XtDisplay(topHandle2)) {
                return;
            }
            if (!OS.XtIsRealized(topHandle2)) {
                Shell shell = control.getShell();
                shell.realizeWidget();
            }
            window2 = OS.XtWindow(topHandle2);
        } else {
            window2 = redrawWindow;
        }
        if (window2 == 0) {
            return;
        }
        XWindowChanges struct = new XWindowChanges();
        struct.sibling = window2;
        int n2 = struct.stack_mode = above ? 0 : 1;
        if (window2 == redrawWindow) {
            struct.stack_mode = 1;
        }
        int screen = OS.XDefaultScreen(display);
        int flags = 96;
        OS.XReconfigureWMWindow(display, window1, screen, flags, struct);
        if (above) {
            if (fixChildren) {
                this.parent.moveAbove(topHandle1, topHandle2);
            }
        } else if (fixChildren) {
            this.parent.moveBelow(topHandle1, topHandle2);
        }
    }

    void showMenu(int x, int y) {
        Event event = new Event();
        event.x = x;
        event.y = y;
        this.sendEvent(35, event);
        if (event.doit && this.menu != null && !this.menu.isDisposed()) {
            if (event.x != x || event.y != y) {
                this.menu.setLocation(event.x, event.y);
            }
            this.menu.setVisible(true);
        }
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)0, (short)0, root_x, root_y);
        return new Point(x - root_x[0], y - root_y[0]);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        short[] root_x = new short[1];
        short[] root_y = new short[1];
        OS.XtTranslateCoords(this.handle, (short)x, (short)y, root_x, root_y);
        return new Point(root_x[0], root_y[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    boolean translateAccelerator(char key, int keysym, XKeyEvent xEvent, boolean doit) {
        return this.menuShell().translateAccelerator(key, keysym, xEvent, doit);
    }

    boolean translateMnemonic(Event event, Control control) {
        if (control == this) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        event.doit = this.mnemonicMatch(event.character);
        return this.traverse(event);
    }

    boolean translateMnemonic(char key, int keysym, XKeyEvent xEvent) {
        int mask;
        int code;
        if (key < ' ') {
            return false;
        }
        if (xEvent.state == 0 ? ((code = this.traversalCode(key, xEvent)) & 0x80) == 0 : (xEvent.state & (mask = 13)) != 8) {
            return false;
        }
        Decorations shell = this.menuShell();
        if (shell.isVisible() && shell.isEnabled()) {
            Event event = new Event();
            event.time = xEvent.time;
            event.detail = 128;
            event.character = key;
            event.keyCode = keysym;
            if (this.setInputState(event, xEvent.state)) {
                return this.translateMnemonic(event, null) || shell.translateMnemonic(event, this);
            }
        }
        return false;
    }

    boolean translateTraversal(int key, XKeyEvent xEvent) {
        int detail = 0;
        int code = this.traversalCode(key, xEvent);
        boolean all = false;
        switch (key) {
            case 65307: {
                all = true;
                detail = 2;
                break;
            }
            case 65293: 
            case 65421: {
                all = true;
                detail = 4;
                break;
            }
            case 65289: {
                boolean next = (xEvent.state & 1) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                boolean next = key == 65364 || key == 65363;
                detail = next ? 64 : 32;
                break;
            }
            case 65365: 
            case 65366: {
                all = true;
                if ((xEvent.state & 4) == 0) {
                    return false;
                }
                detail = key == 65366 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        event.time = xEvent.time;
        if (!this.setKeyState(event, xEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key, XKeyEvent xEvent) {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNtraversalOn;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[1] == 0) {
            return 0;
        }
        int code = 796;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        if (this.getNavigationType() == 0) {
            code |= 0x60;
        }
        return code;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus(next)) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus(next);
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus(next)) continue;
            return true;
        }
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(char key) {
        return this.mnemonicHit(key);
    }

    boolean traverseReturn() {
        return false;
    }

    public void update() {
        this.checkWidget();
        this.update(false);
    }

    void update(boolean all) {
        if (all) {
            this.display.update();
        } else {
            int display = OS.XtDisplay(this.handle);
            if (display == 0) {
                return;
            }
            int window = OS.XtWindow(this.handle);
            if (window == 0) {
                return;
            }
            int event = OS.XtMalloc(96);
            OS.XSync(display, false);
            OS.XSync(display, false);
            while (OS.XCheckWindowEvent(display, window, 32768, event)) {
                OS.XtDispatchEvent(event);
            }
            OS.XtFree(event);
        }
    }

    void updateBackgroundMode() {
        int oldState = this.state & 0x40;
        this.checkBackground();
        if (oldState != (this.state & 0x40)) {
            this.setBackground();
        }
    }

    void updateIM() {
        int[] argList2;
        if (!OS.IsDBLocale) {
            return;
        }
        if (!this.hasFocus()) {
            return;
        }
        int ptr1 = 0;
        int ptr2 = 0;
        if (this.hasIMSupport()) {
            argList2 = new int[]{OS.XmNfontList, this.font.handle};
        } else {
            int x = 0;
            int y = 0;
            Font font = this.font;
            Caret caret = this.getIMCaret();
            if (caret != null) {
                x += caret.x + (caret.width <= 0 ? 2 : caret.width);
                y += caret.y;
                if (caret.font != null) {
                    font = caret.font;
                }
            }
            short[] point = new short[]{(short)x, (short)(y += this.getFontAscent(font.handle))};
            ptr1 = OS.XtMalloc(4);
            OS.memmove(ptr1, point, 4);
            int[] nArray = new int[4];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            int[] argList1 = nArray;
            OS.XtGetValues(this.handle, argList1, argList1.length / 2);
            short[] sArray = new short[4];
            sArray[2] = (short)argList1[1];
            sArray[3] = (short)argList1[3];
            short[] rect = sArray;
            ptr2 = OS.XtMalloc(8);
            OS.memmove(ptr2, rect, 8);
            argList2 = new int[]{OS.XmNfontList, font.handle, OS.XmNspotLocation, ptr1, OS.XmNarea, ptr2};
        }
        OS.XmImSetValues(this.handle, argList2, argList2.length / 2);
        int focusHandle = this.focusHandle();
        if (this.handle != focusHandle) {
            OS.XmImSetValues(focusHandle, argList2, argList2.length / 2);
        }
        if (ptr1 != 0) {
            OS.XtFree(ptr1);
        }
        if (ptr2 != 0) {
            OS.XtFree(ptr2);
        }
    }

    void updateLayout(boolean all) {
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        Display display = this.display;
        display.hideToolTip();
        Shell shell = this.getShell();
        if ((shell.style & 0x4000) != 0 && ((shell.style & 0x80000) == 0 || (this.style & 0x80000) == 0)) {
            shell.forceActive();
        }
        boolean dispatch = true;
        boolean dragging = false;
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 60);
        int clickTime = display.getDoubleClickTime();
        int lastTime = display.lastTime;
        int eventTime = xEvent.time;
        int lastButton = display.lastButton;
        int eventButton = xEvent.button;
        display.clickCount = lastButton == eventButton && lastTime != 0 && Math.abs(lastTime - eventTime) <= clickTime ? ++display.clickCount : 1;
        display.lastTime = eventTime == 0 ? 1 : eventTime;
        display.lastButton = eventButton;
        if (xEvent.button == 2 && (this.state & 0x4000) != 0 && this.hooks(29)) {
            boolean[] consume = new boolean[1];
            if (this.dragDetect(xEvent.x, xEvent.y, true, consume)) {
                dragging = true;
                boolean bl = dispatch = !consume[0];
            }
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (!this.sendMouseEvent(3, xEvent)) {
            dispatch = false;
        }
        if (this.isDisposed()) {
            return 1;
        }
        if (display.clickCount == 2) {
            if (!this.sendMouseEvent(8, xEvent)) {
                dispatch = false;
            }
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (dragging) {
            this.sendDragEvent(xEvent.button, xEvent.state, xEvent.x, xEvent.y, false);
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (xEvent.button == 3) {
            if ((this.menu != null || this.hooks(35)) && !this.isFocusControl()) {
                this.setFocus();
            }
            this.showMenu(xEvent.x_root, xEvent.y_root);
            if (this.isDisposed()) {
                return 1;
            }
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        if (!dispatch) {
            OS.memmove(continue_to_dispatch, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XButtonRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        this.display.hideToolTip();
        XButtonEvent xEvent = new XButtonEvent();
        OS.memmove(xEvent, call_data, 60);
        if (!this.sendMouseEvent(4, xEvent)) {
            OS.memmove(continue_to_dispatch, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XEnterWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        XCrossingEvent xEvent = new XCrossingEvent();
        OS.memmove(xEvent, call_data, 68);
        if (xEvent.mode != 0 && xEvent.mode != 2) {
            return 0;
        }
        if ((xEvent.state & 0x700) != 0) {
            return 0;
        }
        if (xEvent.subwindow != 0) {
            return 0;
        }
        if (!this.sendMouseEvent(6, xEvent)) {
            OS.memmove(continue_to_dispatch, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        XExposeEvent xEvent = new XExposeEvent();
        OS.memmove(xEvent, call_data, 40);
        int xDisplay = OS.XtDisplay(this.handle);
        if (xDisplay == 0) {
            return 0;
        }
        int damageRgn = OS.XCreateRegion();
        OS.XtAddExposureToRegion(call_data, damageRgn);
        Event event = new Event();
        event.count = xEvent.count;
        event.x = xEvent.x;
        event.y = xEvent.y;
        event.width = xEvent.width;
        event.height = xEvent.height;
        GCData data = new GCData();
        data.damageRgn = damageRgn;
        GC gc = event.gc = GC.motif_new(this, data);
        OS.XSetRegion(xDisplay, gc.handle, damageRgn);
        this.sendEvent(9, event);
        event.gc = null;
        gc.dispose();
        OS.XDestroyRegion(damageRgn);
        return 0;
    }

    int XFocusChange(int w, int client_data, int call_data, int continue_to_dispatch) {
        XFocusChangeEvent xEvent = new XFocusChangeEvent();
        OS.memmove(xEvent, call_data, 28);
        if (xEvent.mode != 0) {
            return 0;
        }
        if (xEvent.detail != 0 && xEvent.detail != 2 && xEvent.detail != 3) {
            return 0;
        }
        Display display = this.display;
        Shell shell = this.getShell();
        switch (xEvent.type) {
            case 9: {
                this.xFocusIn(xEvent);
                if (shell.isDisposed()) break;
                shell.setActiveControl(this);
                break;
            }
            case 10: {
                this.xFocusOut(xEvent);
                if (shell.isDisposed() || shell == display.getActiveShell()) break;
                shell.setActiveControl(null);
            }
        }
        return 0;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        this.updateIM();
        if (!this.hasIMSupport()) {
            int focusHandle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
            OS.XmImSetFocusValues(focusHandle, null, 0);
        }
        this.sendFocusEvent(15);
        return 0;
    }

    int xFocusOut(XFocusChangeEvent xEvent) {
        int fontList;
        int focusHandle = OS.XtWindowToWidget(xEvent.display, xEvent.window);
        if (!this.hasIMSupport()) {
            OS.XmImUnsetFocus(focusHandle);
        }
        if (!OS.IsAIX && this.font.handle != (fontList = this.defaultFont().handle)) {
            int[] argList2 = new int[]{OS.XmNfontList, fontList};
            OS.XmImSetValues(focusHandle, argList2, argList2.length / 2);
        }
        this.sendFocusEvent(16);
        if (this.handle == 0) {
            return 0;
        }
        if ((this.style & 0x80000) != 0) {
            int[] nArray = new int[2];
            nArray[0] = OS.XmNtraversalOn;
            int[] argList = nArray;
            OS.XtGetValues(focusHandle, argList, argList.length / 2);
            if (argList[1] != 0 && (this.state & 8) != 0) {
                argList[1] = 0;
                OS.XtSetValues(focusHandle, argList, argList.length / 2);
            }
        }
        return 0;
    }

    int XKeyRelease(int w, int client_data, int call_data, int continue_to_dispatch) {
        XKeyEvent xEvent = new XKeyEvent();
        OS.memmove(xEvent, call_data, 60);
        if (this.menu != null && xEvent.state == 1) {
            byte[] buffer = new byte[1];
            int[] keysym = new int[1];
            OS.XLookupString(xEvent, buffer, buffer.length, keysym, null);
            if (keysym[0] == 65479) {
                this.showMenu(xEvent.x_root, xEvent.y_root);
            }
        }
        return super.XKeyRelease(w, client_data, call_data, continue_to_dispatch);
    }

    int XLeaveWindow(int w, int client_data, int call_data, int continue_to_dispatch) {
        this.display.removeMouseHoverTimeOut();
        this.display.hideToolTip();
        XCrossingEvent xEvent = new XCrossingEvent();
        OS.memmove(xEvent, call_data, 68);
        if (xEvent.mode != 0 && xEvent.mode != 2) {
            return 0;
        }
        if ((xEvent.state & 0x700) != 0) {
            return 0;
        }
        if (xEvent.subwindow != 0) {
            return 0;
        }
        if (!this.sendMouseEvent(7, xEvent)) {
            OS.memmove(continue_to_dispatch, new int[1], 4);
            return 1;
        }
        return 0;
    }

    int XmNhelpCallback(int w, int client_data, int call_data) {
        this.sendHelpEvent(call_data);
        return 0;
    }

    int XPointerMotion(int w, int client_data, int call_data, int continue_to_dispatch) {
        this.display.addMouseHoverTimeOut(this.handle);
        XMotionEvent xEvent = new XMotionEvent();
        OS.memmove(xEvent, call_data, 60);
        if (!this.sendMouseEvent(5, xEvent)) {
            OS.memmove(continue_to_dispatch, new int[1], 4);
            return 1;
        }
        return 0;
    }
}

