/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayRowProcessor
implements SxRowProcessor<Object[]> {
    protected ValueType[] valueTypes;

    @Override
    public void init(ResultSetMetaData rsmd) throws SQLException {
        ArrayList<ValueType> list = new ArrayList<ValueType>();
        int i = 0;
        int columnIndex = 1;
        while (i < rsmd.getColumnCount()) {
            ValueType valueType = this.getValueType(rsmd.getColumnType(columnIndex));
            list.add(valueType);
            ++i;
            ++columnIndex;
        }
        this.valueTypes = list.toArray(new ValueType[list.size()]);
    }

    @Override
    public Object[] process(ResultSet rs) throws SQLException {
        Object[] result = new Object[this.valueTypes.length];
        for (int i = 0; i < this.valueTypes.length; ++i) {
            ValueType valueType = this.valueTypes[i];
            result[i] = valueType.getValue(rs, i + 1);
        }
        return result;
    }

    protected ValueType getValueType(int sqlType) {
        return TypeMappings.getValueType(sqlType);
    }
}

