/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.mapping;

import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverwriteNameMapping
implements NameMapping {
    private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();
    protected final Map<String, String> propertyToColumnMap;
    protected final Map<String, String> columnToPropertyMap = this.createIntermediateMap();
    protected final NameMapping defaultNameMapping;

    public OverwriteNameMapping(Map<String, String> propertyToColumnMap) {
        this(propertyToColumnMap, DEFAULT_COMVERSION);
    }

    public OverwriteNameMapping(Map<String, String> propertyToColumnMap, NameMapping defaultNameMapping) {
        this.propertyToColumnMap = new HashMap<String, String>(propertyToColumnMap);
        for (Map.Entry<String, String> entry : this.propertyToColumnMap.entrySet()) {
            this.columnToPropertyMap.put(entry.getValue(), entry.getKey());
        }
        this.defaultNameMapping = defaultNameMapping;
    }

    @Override
    public String toIntermediateNameFromAttrName(String bindObjectName) {
        return this.propertyToColumnMap.containsKey(bindObjectName) ? bindObjectName : this.defaultNameMapping.toIntermediateNameFromAttrName(bindObjectName);
    }

    @Override
    public String toColumnNameFromAttrName(String bindObjectName) {
        return this.propertyToColumnMap.containsKey(bindObjectName) ? this.propertyToColumnMap.get(bindObjectName) : this.defaultNameMapping.toColumnNameFromAttrName(bindObjectName);
    }

    @Override
    public final Map<String, String> createIntermediateMap() {
        return new CaseInsensitiveHashMap<String>();
    }

    @Override
    public String toIntermediateNameFromColumnName(String columnName) {
        String name = this.columnToPropertyMap.get(columnName);
        return name == null ? this.defaultNameMapping.toIntermediateNameFromColumnName(columnName) : name;
    }
}

