/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.types.BigDecimalType;
import jp.sourceforge.sxdbutils.types.BooleanCharType;
import jp.sourceforge.sxdbutils.types.BooleanNumericType;
import jp.sourceforge.sxdbutils.types.BooleanType;
import jp.sourceforge.sxdbutils.types.ByteArrayType;
import jp.sourceforge.sxdbutils.types.ByteType;
import jp.sourceforge.sxdbutils.types.CharNumericType;
import jp.sourceforge.sxdbutils.types.CharType;
import jp.sourceforge.sxdbutils.types.DateTimestampType;
import jp.sourceforge.sxdbutils.types.DoubleType;
import jp.sourceforge.sxdbutils.types.FloatType;
import jp.sourceforge.sxdbutils.types.IntegerType;
import jp.sourceforge.sxdbutils.types.LongTimestampType;
import jp.sourceforge.sxdbutils.types.LongType;
import jp.sourceforge.sxdbutils.types.ObjectType;
import jp.sourceforge.sxdbutils.types.ShortType;
import jp.sourceforge.sxdbutils.types.SqlDateType;
import jp.sourceforge.sxdbutils.types.StringClobType;
import jp.sourceforge.sxdbutils.types.StringNumericType;
import jp.sourceforge.sxdbutils.types.StringType;
import jp.sourceforge.sxdbutils.types.TimestampType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMappings {
    static final int NCHAR = -15;
    static final int NVARCHAR = -9;
    public static final ValueType BIGDECIMAL_TYPE = new BigDecimalType();
    public static final ValueType BOOLEAN_PRIMITIVE_TYPE = new BooleanType(true);
    public static final ValueType BOOLEAN_OBJECT_TYPE = new BooleanType(false);
    public static final ValueType BOOLEAN_CHAR_PRIMITIVE_TYPE = new BooleanCharType(true);
    public static final ValueType BOOLEAN_CHAR_OBJECT_TYPE = new BooleanCharType(false);
    public static final ValueType BOOLEAN_NUMERIC_PRIMITIVE_TYPE = new BooleanNumericType(true);
    public static final ValueType BOOLEAN_NUMERIC_OBJECT_TYPE = new BooleanNumericType(false);
    public static final ValueType BYTEARRAY_TYPE = new ByteArrayType();
    public static final ValueType BYTE_PRIMITIVE_TYPE = new ByteType(true);
    public static final ValueType BYTE_OBJECT_TYPE = new ByteType(false);
    public static final ValueType CHAR_PRIMITIVE_TYPE = new CharType(true);
    public static final ValueType CHAR_OBJECT_TYPE = new CharType(false);
    public static final ValueType DATE_TIMESTAMP_TYPE = new DateTimestampType();
    public static final ValueType LONG_TIMESTAMP_PRIMITIVE_TYPE = new LongTimestampType(true);
    public static final ValueType LONG_TIMESTAMP_OBJECT_TYPE = new LongTimestampType(false);
    public static final ValueType DOUBLE_PRIMITIVE_TYPE = new DoubleType(true);
    public static final ValueType DOUBLE_OBJECT_TYPE = new DoubleType(false);
    public static final ValueType FLOAT_PRIMITIVE_TYPE = new FloatType(true);
    public static final ValueType FLOAT_OBJECT_TYPE = new FloatType(false);
    public static final ValueType INT_PRIMITIVE_TYPE = new IntegerType(true);
    public static final ValueType INT_OBJECT_TYPE = new IntegerType(false);
    public static final ValueType LONG_PRIMITIVE_TYPE = new LongType(true);
    public static final ValueType LONG_OBJECT_TYPE = new LongType(false);
    public static final ValueType OBJECT_TYPE = new ObjectType();
    public static final ValueType SHORT_PRIMITIVE_TYPE = new ShortType(true);
    public static final ValueType SHORT_OBJECT_TYPE = new ShortType(false);
    public static final ValueType SQLDATE_OBJECT_TYPE = new SqlDateType();
    public static final ValueType TIMESTAMP_OBJECT_TYPE = new TimestampType();
    public static final ValueType STRING_CLOB_TYPE = new StringClobType();
    public static final ValueType STRING_TYPE = new StringType();
    public static final ValueType CHAR_NUMERIC_PRIMITIVE_TYPE = new CharNumericType(true);
    public static final ValueType CHAR_NUMERIC_OBJECT_TYPE = new CharNumericType(false);
    public static final ValueType STRING_NUMERIC_OBJECT_TYPE = new StringNumericType();
    static Map<Key, ValueType> valueTypes = new HashMap<Key, ValueType>();
    static Map<Class<?>, ValueType> defaultValueTypes = new HashMap();

    private TypeMappings() {
    }

    static void registerValueType(Class<?> clazz, int sqlType, ValueType type) {
        TypeMappings.registerValueType(new Key(clazz, sqlType), type);
    }

    static void registerAllNumericValueType(Class<?> clazz, ValueType type) {
        TypeMappings.registerValueType(clazz, 3, type);
        TypeMappings.registerValueType(clazz, 2, type);
        TypeMappings.registerValueType(clazz, 4, type);
        TypeMappings.registerValueType(clazz, -5, type);
        TypeMappings.registerValueType(clazz, 7, type);
        TypeMappings.registerValueType(clazz, 8, type);
        TypeMappings.registerValueType(clazz, 6, type);
        TypeMappings.registerValueType(clazz, 5, type);
        TypeMappings.registerValueType(clazz, -6, type);
    }

    static void registerAllStringValueType(Class<?> clazz, ValueType type) {
        TypeMappings.registerValueType(clazz, 12, type);
        TypeMappings.registerValueType(clazz, -1, type);
        TypeMappings.registerValueType(clazz, 1, type);
        TypeMappings.registerValueType(clazz, -15, type);
        TypeMappings.registerValueType(clazz, -9, type);
    }

    static void registerAllBinaryValueType(Class<?> clazz, ValueType type) {
        TypeMappings.registerValueType(clazz, -2, type);
        TypeMappings.registerValueType(clazz, 2004, type);
        TypeMappings.registerValueType(clazz, -3, type);
        TypeMappings.registerValueType(clazz, -4, type);
    }

    static void registerAllDateValueType(Class<?> clazz, ValueType type) {
        TypeMappings.registerValueType(clazz, 93, type);
        TypeMappings.registerValueType(clazz, 91, type);
        TypeMappings.registerValueType(clazz, 92, type);
    }

    static void registerValueType(Key key, ValueType type) {
        valueTypes.put(key, type);
    }

    static void registerDefaultValueType(Class<?> clazz, ValueType type) {
        defaultValueTypes.put(clazz, type);
    }

    public static ValueType getValueType(Class<?> clazz, int sqlType) {
        ValueType result = valueTypes.get(new Key(clazz, sqlType));
        return result == null ? OBJECT_TYPE : result;
    }

    public static ValueType getValueType(int sqlType) {
        switch (sqlType) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return STRING_TYPE;
            }
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return BIGDECIMAL_TYPE;
            }
            case 2005: {
                return STRING_CLOB_TYPE;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return BYTEARRAY_TYPE;
            }
            case 91: 
            case 92: 
            case 93: {
                return DATE_TIMESTAMP_TYPE;
            }
        }
        return OBJECT_TYPE;
    }

    public static ValueType getValueType(Class<?> type) {
        ValueType result = defaultValueTypes.get(type);
        return result == null ? OBJECT_TYPE : result;
    }

    static {
        TypeMappings.registerAllNumericValueType(BigDecimal.class, BIGDECIMAL_TYPE);
        TypeMappings.registerValueType(Boolean.TYPE, 16, BOOLEAN_PRIMITIVE_TYPE);
        TypeMappings.registerValueType(Boolean.class, 16, BOOLEAN_OBJECT_TYPE);
        TypeMappings.registerValueType(Boolean.TYPE, 1, BOOLEAN_CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerValueType(Boolean.class, 1, BOOLEAN_CHAR_OBJECT_TYPE);
        TypeMappings.registerValueType(Boolean.TYPE, 12, BOOLEAN_CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerValueType(Boolean.class, 12, BOOLEAN_CHAR_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Boolean.TYPE, BOOLEAN_NUMERIC_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Boolean.class, BOOLEAN_NUMERIC_PRIMITIVE_TYPE);
        TypeMappings.registerAllBinaryValueType(byte[].class, BYTEARRAY_TYPE);
        TypeMappings.registerAllNumericValueType(Byte.TYPE, BYTE_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Byte.class, BYTE_OBJECT_TYPE);
        TypeMappings.registerAllStringValueType(Character.TYPE, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Character.TYPE, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerAllStringValueType(Character.class, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Character.class, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Character.TYPE, CHAR_NUMERIC_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Character.class, CHAR_NUMERIC_OBJECT_TYPE);
        TypeMappings.registerAllDateValueType(java.util.Date.class, DATE_TIMESTAMP_TYPE);
        TypeMappings.registerAllDateValueType(Timestamp.class, TIMESTAMP_OBJECT_TYPE);
        TypeMappings.registerAllDateValueType(Long.TYPE, LONG_TIMESTAMP_PRIMITIVE_TYPE);
        TypeMappings.registerAllDateValueType(Long.class, LONG_TIMESTAMP_OBJECT_TYPE);
        TypeMappings.registerValueType(Date.class, 91, SQLDATE_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Double.TYPE, DOUBLE_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Double.class, DOUBLE_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Float.TYPE, FLOAT_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Float.class, FLOAT_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Integer.TYPE, INT_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Integer.class, INT_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Long.TYPE, LONG_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Long.class, LONG_OBJECT_TYPE);
        TypeMappings.registerAllNumericValueType(Short.TYPE, SHORT_PRIMITIVE_TYPE);
        TypeMappings.registerAllNumericValueType(Short.class, SHORT_OBJECT_TYPE);
        TypeMappings.registerAllStringValueType(String.class, STRING_TYPE);
        TypeMappings.registerAllNumericValueType(String.class, STRING_TYPE);
        TypeMappings.registerValueType(String.class, 2005, STRING_CLOB_TYPE);
        TypeMappings.registerAllNumericValueType(String.class, STRING_NUMERIC_OBJECT_TYPE);
        TypeMappings.registerAllDateValueType(String.class, STRING_TYPE);
        TypeMappings.registerAllNumericValueType(Object.class, OBJECT_TYPE);
        TypeMappings.registerAllStringValueType(Object.class, OBJECT_TYPE);
        TypeMappings.registerAllBinaryValueType(Object.class, OBJECT_TYPE);
        TypeMappings.registerAllDateValueType(Object.class, OBJECT_TYPE);
        TypeMappings.registerValueType(Object.class, 2005, STRING_CLOB_TYPE);
        TypeMappings.registerValueType(Object.class, 16, STRING_CLOB_TYPE);
        TypeMappings.registerDefaultValueType(String.class, STRING_TYPE);
        TypeMappings.registerDefaultValueType(Character.TYPE, CHAR_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(Character.class, CHAR_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Boolean.TYPE, BOOLEAN_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(Boolean.class, BOOLEAN_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Integer.TYPE, INT_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(Integer.class, INT_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Long.TYPE, LONG_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(Long.class, LONG_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Short.TYPE, SHORT_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(Short.class, SHORT_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Float.TYPE, FLOAT_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(Float.class, FLOAT_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Byte.TYPE, BYTE_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(Byte.class, BYTE_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(Double.TYPE, DOUBLE_PRIMITIVE_TYPE);
        TypeMappings.registerDefaultValueType(Double.class, DOUBLE_OBJECT_TYPE);
        TypeMappings.registerDefaultValueType(BigDecimal.class, BIGDECIMAL_TYPE);
        TypeMappings.registerDefaultValueType(java.util.Date.class, DATE_TIMESTAMP_TYPE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Key {
        final Class<?> clazz;
        final int sqlType;

        public Key(Class<?> clazz, int sqlType) {
            this.clazz = clazz;
            this.sqlType = sqlType;
        }

        public int hashCode() {
            int result = 17;
            result = result * 31 + this.clazz.hashCode();
            result = result * 31 + this.sqlType;
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.clazz.equals(other.clazz) && this.sqlType == other.sqlType;
            }
            return false;
        }
    }
}

