package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.tiger.SxQueryRunner;
import jp.sourceforge.sxdbutils.tiger.SxResultSetHandler;
import jp.sourceforge.sxdbutils.tiger.handlers.ListHandler;
import jp.sourceforge.sxdbutils.tiger.handlers.SingleHandler;
import jp.sourceforge.sxdbutils.tiger.processors.MapRowProcessor;
import jp.sourceforge.sxdbutils.tiger.processors.ValueRowProcessor;

public abstract class AbstractQueryTemplate implements QueryTemplate {

	protected abstract Connection getConnection() throws SQLException;

	public Map<String, Object> executeQueryToMap(Query query)
			throws SQLException {
		SxResultSetHandler<Map<String, Object>> handler = new SingleHandler<Map<String, Object>>(
				new MapRowProcessor<Object>());
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, handler);
	}

	public List<Map<String, Object>> executeQueryToMapList(Query query)
			throws SQLException {
		SxResultSetHandler<List<Map<String, Object>>> handler = new ListHandler<Map<String, Object>>(
				new MapRowProcessor<Object>());
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, handler);
	}

	public <V> V executeQueryToValue(Query query, String columnName,
			Class<V> type) throws SQLException {
		SxResultSetHandler<V> handler = new SingleHandler<V>(
				new ValueRowProcessor<V>(columnName, type));
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, handler);
	}

	public <V> List<V> executeQueryToValueList(Query query, String columnName,
			Class<V> type) throws SQLException {
		SxResultSetHandler<List<V>> handler = new ListHandler<V>(
				new ValueRowProcessor<V>(columnName, type));
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, handler);
	}

}
