package jp.sourceforge.sxdbutils.tiger.rstable;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import jp.sourceforge.sxdbutils.rstable.ResultColumnMetaData;
import jp.sourceforge.sxdbutils.rstable.ResultColumnRepository;
import jp.sourceforge.sxdbutils.rstable.ResultRow;

public class BasicResultTable implements ResultTable, Serializable {

	private static final long serialVersionUID = 1L;
	private final List<ResultRow> resultRows;
	private final ResultColumnRepository columnRepository;

	public BasicResultTable(ResultColumnRepository columnRepository, List<ResultRow> resultRows) {
		this.resultRows = resultRows;
		this.columnRepository = columnRepository;
	}

	public ResultColumnMetaData[] getColumnMetaDatas() {
		ResultColumnMetaData[] result = new ResultColumnMetaData[columnRepository.size()];
		for (int i = 0; i < columnRepository.size(); i++) {
			result[i] = columnRepository.getResultColumn(i).getColumnMetaData();
		}
		return result;
	}

	public void add(int index, ResultRow element) {
		resultRows.add(index, element);
	}

	public boolean add(ResultRow e) {
		return resultRows.add(e);
	}

	public boolean addAll(Collection<? extends ResultRow> c) {
		return resultRows.addAll(c);
	}

	public boolean addAll(int index, Collection<? extends ResultRow> c) {
		return resultRows.addAll(index, c);
	}

	public void clear() {
		resultRows.clear();
	}

	public boolean contains(Object o) {
		return resultRows.contains(o);
	}

	public boolean containsAll(Collection<?> c) {
		return resultRows.containsAll(c);
	}

	public ResultRow get(int index) {
		return resultRows.get(index);
	}

	public int indexOf(Object o) {
		return resultRows.indexOf(o);
	}

	public boolean isEmpty() {
		return resultRows.isEmpty();
	}

	public Iterator<ResultRow> iterator() {
		return resultRows.iterator();
	}

	public int lastIndexOf(Object o) {
		return resultRows.lastIndexOf(o);
	}

	public ListIterator<ResultRow> listIterator() {
		return resultRows.listIterator();
	}

	public ListIterator<ResultRow> listIterator(int index) {
		return resultRows.listIterator(index);
	}

	public ResultRow remove(int index) {
		return resultRows.remove(index);
	}

	public boolean remove(Object o) {
		return resultRows.remove(o);
	}

	public boolean removeAll(Collection<?> c) {
		return resultRows.removeAll(c);
	}

	public boolean retainAll(Collection<?> c) {
		return resultRows.retainAll(c);
	}

	public ResultRow set(int index, ResultRow element) {
		return resultRows.set(index, element);
	}

	public int size() {
		return resultRows.size();
	}

	public List<ResultRow> subList(int fromIndex, int toIndex) {
		return resultRows.subList(fromIndex, toIndex);
	}

	public Object[] toArray() {
		return resultRows.toArray();
	}

	public <T> T[] toArray(T[] a) {
		return resultRows.toArray(a);
	}

	public BigDecimal getBigDecimal(int row, int columnIndex) {
		return getResultRow(row).getBigDecimal(columnIndex);
	}

	public BigDecimal getBigDecimal(int row, String columnLabel) {
		return getResultRow(row).getBigDecimal(columnLabel);
	}

	public boolean getBoolean(int row, int columnIndex) {
		return getResultRow(row).getBoolean(columnIndex);
	}

	public boolean getBoolean(int row, String columnLabel) {
		return getResultRow(row).getBoolean(columnLabel);
	}

	public Boolean getBooleanObject(int row, int columnIndex) {
		return getResultRow(row).getBooleanObject(columnIndex);
	}

	public Boolean getBooleanObject(int row, String columnLabel) {
		return getResultRow(row).getBooleanObject(columnLabel);
	}

	public byte getByte(int row, int columnIndex) {
		return getResultRow(row).getByte(columnIndex);
	}

	public byte getByte(int row, String columnLabel) {
		return getResultRow(row).getByte(columnLabel);
	}

	public Byte getByteObject(int row, int columnIndex) {
		return getResultRow(row).getByteObject(columnIndex);
	}

	public Byte getByteObject(int row, String columnLabel) {
		return getResultRow(row).getByteObject(columnLabel);
	}

	public byte[] getBytes(int row, int columnIndex) {
		return getResultRow(row).getBytes(columnIndex);
	}

	public byte[] getBytes(int row, String columnLabel) {
		return getResultRow(row).getBytes(columnLabel);
	}

	public char getChar(int row, int columnIndex) {
		return getResultRow(row).getChar(columnIndex);
	}

	public char getChar(int row, String columnLabel) {
		return getResultRow(row).getChar(columnLabel);
	}

	public Character getCharacter(int row, int columnIndex) {
		return getResultRow(row).getCharacter(columnIndex);
	}

	public Character getCharacter(int row, String columnLabel) {
		return getResultRow(row).getCharacter(columnLabel);
	}

	public Date getDate(int row, int columnIndex) {
		return getResultRow(row).getDate(columnIndex);
	}

	public Date getDate(int row, String columnLabel) {
		return getResultRow(row).getDate(columnLabel);
	}

	public double getDouble(int row, int columnIndex) {
		return getResultRow(row).getDouble(columnIndex);
	}

	public double getDouble(int row, String columnLabel) {
		return getResultRow(row).getDouble(columnLabel);
	}

	public Double getDoubleObject(int row, int columnIndex) {
		return getResultRow(row).getDoubleObject(columnIndex);
	}

	public Double getDoubleObject(int row, String columnLabel) {
		return getResultRow(row).getDoubleObject(columnLabel);
	}

	public float getFloat(int row, int columnIndex) {
		return getResultRow(row).getFloat(columnIndex);
	}

	public float getFloat(int row, String columnLabel) {
		return getResultRow(row).getFloat(columnLabel);
	}

	public Float getFloatObject(int row, int columnIndex) {
		return getResultRow(row).getFloatObject(columnIndex);
	}

	public Float getFloatObject(int row, String columnLabel) {
		return getResultRow(row).getFloatObject(columnLabel);
	}

	public int getInt(int row, int columnIndex) {
		return getResultRow(row).getInt(columnIndex);
	}

	public int getInt(int row, String columnLabel) {
		return getResultRow(row).getInt(columnLabel);
	}

	public Integer getInteger(int row, int columnIndex) {
		return getResultRow(row).getInteger(columnIndex);
	}

	public Integer getInteger(int row, String columnLabel) {
		return getResultRow(row).getInteger(columnLabel);
	}

	public long getLong(int row, int columnIndex) {
		return getResultRow(row).getLong(columnIndex);
	}

	public long getLong(int row, String columnLabel) {
		return getResultRow(row).getLong(columnLabel);
	}

	public Long getLongObject(int row, int columnIndex) {
		return getResultRow(row).getLongObject(columnIndex);
	}

	public Long getLongObject(int row, String columnLabel) {
		return getResultRow(row).getLongObject(columnLabel);
	}

	public short getShort(int row, int columnIndex) {
		return getResultRow(row).getShort(columnIndex);
	}

	public short getShort(int row, String columnLabel) {
		return getResultRow(row).getShort(columnLabel);
	}

	public Short getShortObject(int row, int columnIndex) {
		return getResultRow(row).getShortObject(columnIndex);
	}

	public Short getShortObject(int row, String columnLabel) {
		return getResultRow(row).getShortObject(columnLabel);
	}

	public java.sql.Date getSqlDate(int row, int columnIndex) {
		return getResultRow(row).getSqlDate(columnIndex);
	}

	public java.sql.Date getSqlDate(int row, String columnLabel) {
		return getResultRow(row).getSqlDate(columnLabel);
	}

	public String getString(int row, int columnIndex) {
		return getResultRow(row).getString(columnIndex);
	}

	public String getString(int row, String columnLabel) {
		return getResultRow(row).getString(columnLabel);
	}

	public Time getTime(int row, int columnIndex) {
		return getResultRow(row).getTime(columnIndex);
	}

	public Time getTime(int row, String columnLabel) {
		return getResultRow(row).getTime(columnLabel);
	}

	public Timestamp getTimestamp(int row, int columnIndex) {
		return getResultRow(row).getTimestamp(columnIndex);
	}

	public Timestamp getTimestamp(int row, String columnLabel) {
		return getResultRow(row).getTimestamp(columnLabel);
	}

	protected ResultRow getResultRow(int row) {
		return resultRows.get(row);
	}

	public Object getObject(int row, int columnIndex) {
		return getResultRow(row).getObject(columnIndex);
	}

	public Object getObject(int row, String columnLabel) {
		return getResultRow(row).getObject(columnLabel);
	}

}
