package jp.sourceforge.sxdbutils.tiger.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;

public class SxRowProcessorDelegate<S, P extends jp.sourceforge.sxdbutils.SxRowProcessor>
		implements SxRowProcessor<S> {
	protected final P delegate;

	public SxRowProcessorDelegate(P delegate) {
		this.delegate = delegate;
	}

	public void init(ResultSetMetaData rsmd) throws SQLException {
		delegate.init(rsmd);
	}

	public S process(ResultSet rs) throws SQLException {
		@SuppressWarnings("unchecked")
		S result = (S) delegate.process(rs);
		return result;
	}

}
