package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;

public abstract class AbstractCrudTemplate<E> implements CrudTemplate<E> {

	protected abstract Connection getConnection() throws SQLException;

	protected abstract Class<E> getEntityClass();

	protected abstract <X extends E> SxRowProcessor<X> createRowProcessor(
			Class<X> entityClass);

	protected class InsertTemplateImpl extends AbstractInsertTemplate<E> {
		public InsertTemplateImpl(QueryFactory insertFactory) {
			super(insertFactory);
		}

		@Override
		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class UpdateTemplateImpl extends AbstractUpdateTemplate<E> {
		public UpdateTemplateImpl(QueryFactory updateFactory) {
			super(updateFactory);
		}

		@Override
		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class DeleteTemplateImpl extends AbstractDeleteTemplate<E> {
		public DeleteTemplateImpl(QueryFactory deleteFactory) {
			super(deleteFactory);
		}

		@Override
		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class SelectTemplateImpl extends AbstractSelectTemplate<E> {
		@Override
		protected <X extends E> SxRowProcessor<X> createRowProcessor(
				Class<X> targetClass) {
			return AbstractCrudTemplate.this.createRowProcessor(targetClass);
		}

		@Override
		protected Class<E> getEntityClass() {
			return AbstractCrudTemplate.this.getEntityClass();
		}

		@Override
		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected final SelectTemplate<E> selectTemplate;
	protected final InsertTemplate<E> insertTemplate;
	protected final UpdateTemplate<E> updateTemplate;
	protected final DeleteTemplate<E> deleteTemplate;

	public AbstractCrudTemplate(QueryFactory insertFactory,
			QueryFactory updateFactory, QueryFactory deleteFactory) {
		this.selectTemplate = new SelectTemplateImpl();
		this.insertTemplate = new InsertTemplateImpl(insertFactory);
		this.updateTemplate = new UpdateTemplateImpl(updateFactory);
		this.deleteTemplate = new DeleteTemplateImpl(deleteFactory);

	}

	public int[] delete(Collection<E> entities) throws SQLException {
		return deleteTemplate.delete(entities);
	}

	public int delete(E entity) throws SQLException {
		return deleteTemplate.delete(entity);
	}

	public int[] deleteBatch(Collection<E> entities) throws SQLException {
		return deleteTemplate.deleteBatch(entities);
	}

	public int insert(E entity) throws SQLException {
		return insertTemplate.insert(entity);
	}

	public int[] insert(Collection<E> entities) throws SQLException {
		return insertTemplate.insert(entities);
	}

	public int[] insertBatch(Collection<E> entities) throws SQLException {
		return insertTemplate.insertBatch(entities);
	}

	public <X extends E> X executeQueryToEntity(Query query, Class<X> entityClass)
			throws SQLException {
		return selectTemplate.executeQueryToEntity(query, entityClass);
	}

	public E executeQueryToBean(Query query) throws SQLException {
		return selectTemplate.executeQueryToBean(query);
	}

	public <X extends E> List<X> executeQueryToEntityList(Query query,
			Class<X> entityClass) throws SQLException {
		return selectTemplate.executeQueryToEntityList(query, entityClass);
	}

	public List<E> executeQueryToEntityList(Query query) throws SQLException {
		return selectTemplate.executeQueryToEntityList(query);
	}

	public int[] update(Collection<E> entities) throws SQLException {
		return updateTemplate.update(entities);
	}

	public int update(E entity) throws SQLException {
		return updateTemplate.update(entity);
	}

	public int[] updateBatch(Collection<E> entities) throws SQLException {
		return updateTemplate.updateBatch(entities);
	}

}
