/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.types;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import jp.sourceforge.sxdbutils.types.AbstractValueType;
import jp.sourceforge.sxdbutils.util.OthersUtils;

public class CharNumericType
extends AbstractValueType {
    private static final Character NULL_VALUE = new Character('0');
    private static final BigDecimal ZERO = new BigDecimal("0");
    private final boolean primitive;

    public CharNumericType(boolean primitive) {
        this.primitive = primitive;
    }

    public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
        BigDecimal bd = rset.getBigDecimal(columnIndex);
        if (bd == null) {
            return this.primitive ? NULL_VALUE : null;
        }
        int i = bd.intValue();
        if (0 <= i && i <= 16) {
            return new Character(Integer.toHexString(i).charAt(0));
        }
        return this.primitive ? NULL_VALUE : null;
    }

    public Object toBindParameterValue(Object value) {
        if (!OthersUtils.isNumber("0x" + value.toString())) {
            return ZERO;
        }
        return Integer.valueOf(value.toString(), 16);
    }
}

