/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.mapping;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;

public class OverwriteNameMapping
implements NameMapping {
    private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();
    protected final Map propertyToColumnMap;
    protected final Map columnToPropertyMap = this.createIntermediateMap();
    protected final NameMapping defaultNameMapping;

    public OverwriteNameMapping(Map propertyToColumnMap) {
        this(propertyToColumnMap, DEFAULT_COMVERSION);
    }

    public OverwriteNameMapping(Map propertyToColumnMap, NameMapping defaultNameMapping) {
        this.propertyToColumnMap = new HashMap(propertyToColumnMap);
        Iterator iterator = this.propertyToColumnMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.columnToPropertyMap.put(entry.getValue(), entry.getKey());
        }
        this.defaultNameMapping = defaultNameMapping;
    }

    public String toIntermediateNameFromAttrName(String bindObjectName) {
        return this.propertyToColumnMap.containsKey(bindObjectName) ? bindObjectName : this.defaultNameMapping.toIntermediateNameFromAttrName(bindObjectName);
    }

    public String toColumnNameFromAttrName(String bindObjectName) {
        return this.propertyToColumnMap.containsKey(bindObjectName) ? (String)this.propertyToColumnMap.get(bindObjectName) : this.defaultNameMapping.toColumnNameFromAttrName(bindObjectName);
    }

    public final Map createIntermediateMap() {
        return new CaseInsensitiveHashMap();
    }

    public String toIntermediateNameFromColumnName(String columnName) {
        String name = (String)this.columnToPropertyMap.get(columnName);
        return name == null ? this.defaultNameMapping.toIntermediateNameFromColumnName(columnName) : name;
    }
}

