/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import jp.sourceforge.sxdbutils.SxQueryRunner;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;

public class BeanPersistenceHelper {
    public int execute(Connection connection, QueryFactory factory, Object bean) throws SQLException {
        SxQueryRunner runner = new SxQueryRunner();
        return runner.update(connection, factory.toQuery(bean));
    }

    public int[] execute(Connection connection, QueryFactory factory, Collection beans) throws SQLException {
        ArrayList<Query> queries = new ArrayList<Query>();
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            Object bean = iterator.next();
            Query q = factory.toQuery(bean);
            queries.add(q);
        }
        int[] result = new int[queries.size()];
        SxQueryRunner runner = new SxQueryRunner();
        for (int i = 0; i < queries.size(); ++i) {
            result[i] = runner.update(connection, (Query)queries.get(i));
        }
        return result;
    }

    public int[] executeBatch(Connection connection, QueryFactory factory, Collection beans) throws SQLException {
        Object[][] batchParams = new Object[beans.size()][];
        int i = 0;
        Iterator iterator = beans.iterator();
        while (iterator.hasNext()) {
            Object bean = iterator.next();
            batchParams[i++] = factory.toBindParameters(bean);
        }
        SxQueryRunner runner = new SxQueryRunner();
        return runner.batch(connection, factory.getSql(), batchParams);
    }
}

